/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.tile.misc;

import com.buuz135.industrial.proxy.client.infopiece.ArrowInfoPiece;
import com.buuz135.industrial.proxy.client.infopiece.IHasDisplayString;
import com.buuz135.industrial.proxy.client.infopiece.TextInfoPiece;
import com.buuz135.industrial.tile.CustomSidedTileEntity;
import java.util.List;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.ndrei.teslacorelib.TeslaCoreLib;
import net.ndrei.teslacorelib.gui.BasicTeslaGuiContainer;
import net.ndrei.teslacorelib.gui.IGuiContainerPiece;
import net.ndrei.teslacorelib.gui.LockedInventoryTogglePiece;
import net.ndrei.teslacorelib.inventory.BoundingRectangle;
import net.ndrei.teslacorelib.inventory.SyncProviderLevel;
import net.ndrei.teslacorelib.netsync.SimpleNBTMessage;
import net.ndrei.teslacorelib.tileentities.SidedTileEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemSplitterTile
extends CustomSidedTileEntity
implements IHasDisplayString {
    private IItemHandlerModifiable input = this.addSimpleInventory(3, "input", EnumDyeColor.BLUE, "input items", new BoundingRectangle(18, 25, 18, 54), (stack, integer) -> true, (stack, integer) -> false, true, 0);
    private IItemHandlerModifiable fakeOut = this.addSimpleInventory(0, "out", EnumDyeColor.ORANGE, "output items", new BoundingRectangle(30, 90, 0, 0), (stack, integer) -> false, (stack, integer) -> false, false, 0);
    private int tick = 1;
    private int size = 1;

    public ItemSplitterTile() {
        super(ItemSplitterTile.class.getName().hashCode());
        this.registerSyncIntPart("size", nbtTagInt -> {
            this.size = nbtTagInt.func_150287_d();
        }, () -> new NBTTagInt(this.size), SyncProviderLevel.GUI);
    }

    protected void innerUpdate() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (++this.tick <= 4) {
            return;
        }
        block0: for (EnumFacing facing : this.getSideConfig().getSidesForColor(EnumDyeColor.ORANGE)) {
            BlockPos side = this.field_174879_c.func_177972_a(facing);
            if (this.field_145850_b.func_175625_s(side) == null || !this.field_145850_b.func_175625_s(side).hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d())) continue;
            TileEntity tileEntity = this.field_145850_b.func_175625_s(side);
            IItemHandler handler = (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d());
            for (int i = 0; i < handler.getSlots(); ++i) {
                if (!handler.getStackInSlot(i).func_190926_b() && (handler.getStackInSlot(i).func_190916_E() >= this.size || handler.getStackInSlot(i).func_190916_E() >= handler.getStackInSlot(i).func_77976_d())) continue;
                ItemStack handlerStack = handler.getStackInSlot(i);
                ItemStack posible = ItemStack.field_190927_a;
                boolean hasWorked = false;
                for (int x = 0; x < this.input.getSlots(); ++x) {
                    if (this.input.getStackInSlot(x).func_190926_b() || !handlerStack.func_190926_b() && !this.input.getStackInSlot(x).func_77969_a(handlerStack) || (posible = this.input.getStackInSlot(x)).func_190926_b()) continue;
                    ItemStack def = posible.func_77946_l();
                    def.func_190920_e(1);
                    def = handler.insertItem(i, def, false);
                    if (!def.func_190926_b()) continue;
                    posible.func_190918_g(1);
                    hasWorked = true;
                    break;
                }
                if (hasWorked) continue block0;
            }
        }
        this.tick = 0;
    }

    protected boolean supportsAddons() {
        return false;
    }

    @NotNull
    public List<IGuiContainerPiece> getGuiContainerPieces(BasicTeslaGuiContainer<?> container) {
        List pieces = super.getGuiContainerPieces(container);
        pieces.add(new LockedInventoryTogglePiece(45, 83, (SidedTileEntity)this, EnumDyeColor.BLUE));
        pieces.add(new ArrowInfoPiece(50, 28, 17, 56, "text.industrialforegoing.button.decrease_stack"){

            protected void clicked() {
                if (TeslaCoreLib.INSTANCE.isClientSide()) {
                    ItemSplitterTile.this.sendToServer(ItemSplitterTile.this.setupSpecialNBTMessage("STACK_DECREASE"));
                }
            }
        });
        pieces.add(new ArrowInfoPiece(156, 28, 33, 56, "text.industrialforegoing.button.increase_stack"){

            protected void clicked() {
                if (TeslaCoreLib.INSTANCE.isClientSide()) {
                    ItemSplitterTile.this.sendToServer(ItemSplitterTile.this.setupSpecialNBTMessage("STACK_INCREASE"));
                }
            }
        });
        pieces.add(0, new TextInfoPiece(this, 0, 75, 31));
        return pieces;
    }

    @Nullable
    protected SimpleNBTMessage processClientMessage(String messageType, NBTTagCompound compound) {
        super.processClientMessage(messageType, compound);
        if (messageType.equals("STACK_INCREASE")) {
            this.size = Math.min(this.size + 1, 64);
            this.partialSync("size", true);
        }
        if (messageType.equals("STACK_DECREASE")) {
            this.size = Math.max(this.size - 1, 1);
            this.partialSync("size", true);
        }
        return null;
    }

    private ItemStack getStack(ItemStack stack) {
        for (int i = 0; i < this.input.getSlots(); ++i) {
            if (this.input.getStackInSlot(i).func_190926_b() || !stack.func_190926_b() && !this.input.getStackInSlot(i).func_77969_a(stack)) continue;
            return this.input.getStackInSlot(i);
        }
        return ItemStack.field_190927_a;
    }

    public void func_145839_a(NBTTagCompound compound) {
        this.tick = compound.func_74762_e("Tick");
        this.size = compound.func_74762_e("Size");
        super.func_145839_a(compound);
    }

    @NotNull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        NBTTagCompound tagCompound = super.func_189515_b(compound);
        tagCompound.func_74768_a("Tick", this.tick);
        tagCompound.func_74768_a("Stack", this.size);
        return tagCompound;
    }

    @Override
    public String getString(int id) {
        return TextFormatting.DARK_GRAY + new TextComponentTranslation("text.industrialforegoing.display.stacksize", new Object[0]).func_150254_d() + " " + TextFormatting.DARK_GRAY + this.size;
    }
}

