/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.tile.block;

import com.buuz135.industrial.api.plant.PlantRecollectable;
import com.buuz135.industrial.book.BookCategory;
import com.buuz135.industrial.config.CustomConfiguration;
import com.buuz135.industrial.proxy.ItemRegistry;
import com.buuz135.industrial.registry.IFRegistries;
import com.buuz135.industrial.tile.agriculture.CropRecolectorTile;
import com.buuz135.industrial.tile.block.CustomAreaOrientedBlock;
import com.buuz135.industrial.utils.RecipeUtils;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextComponentTranslation;
import net.ndrei.teslacorelib.items.MachineCaseItem;

public class CropRecolectorBlock
extends CustomAreaOrientedBlock<CropRecolectorTile> {
    private int sludgeOperation;
    private int treeOperations;
    private boolean reducedChunkUpdates;
    private int maxDistanceTreeBlocksScan;

    public CropRecolectorBlock() {
        super("crop_recolector", CropRecolectorTile.class, Material.field_151576_e, 400, 40, CustomAreaOrientedBlock.RangeType.FRONT, 11, 0, true);
    }

    @Override
    public void getMachineConfig() {
        super.getMachineConfig();
        this.sludgeOperation = CustomConfiguration.config.getInt("sludgeOperation", "machines." + this.getRegistryName().func_110623_a().toString(), 20, 1, 8000, "How much sludge is produced when the machine does an operation");
        this.treeOperations = CustomConfiguration.config.getInt("treeOperations", "machines." + this.getRegistryName().func_110623_a().toString(), 10, 1, 1024, "Amount of operations done when chopping a tree");
        this.reducedChunkUpdates = CustomConfiguration.config.getBoolean("reducedChunkUpdates", "machines." + this.getRegistryName().func_110623_a().toString(), false, "When enabled it will chop down the tree in one go but still consuming the same power");
        this.maxDistanceTreeBlocksScan = CustomConfiguration.config.getInt("maxDistanceTreeBlocksScan", "machines." + this.getRegistryName().func_110623_a().toString(), 100, 0, Integer.MAX_VALUE, "How far the trees will me scanned to be chopped from the ground. WARNING: Increasing this number with big trees may cause some lag when scanning for a tree.");
    }

    public int getSludgeOperation() {
        return this.sludgeOperation;
    }

    public int getTreeOperations() {
        return this.treeOperations;
    }

    public boolean isReducedChunkUpdates() {
        return this.reducedChunkUpdates;
    }

    public int getMaxDistanceTreeBlocksScan() {
        return this.maxDistanceTreeBlocksScan;
    }

    @Override
    public void createRecipe() {
        RecipeUtils.addShapedRecipe(new ItemStack((Block)this), new Object[]{"php", "ama", "grg", Character.valueOf('p'), ItemRegistry.plastic, Character.valueOf('h'), Items.field_151019_K, Character.valueOf('a'), Items.field_151036_c, Character.valueOf('m'), MachineCaseItem.INSTANCE, Character.valueOf('g'), "gearGold", Character.valueOf('r'), Items.field_151137_ax});
    }

    @Override
    public BookCategory getCategory() {
        return BookCategory.AGRICULTURE;
    }

    @Override
    public List<String> getTooltip(ItemStack stack) {
        List<String> tooltip = super.getTooltip(stack);
        tooltip.add(new TextComponentTranslation("text.industrialforegoing.leaf_shearing_addon", new Object[0]).func_150254_d());
        tooltip.add(new TextComponentTranslation("text.industrialforegoing.can_harvest", new Object[0]).func_150254_d());
        for (PlantRecollectable recollectable : IFRegistries.PLANT_RECOLLECTABLES_REGISTRY.getValues()) {
            for (String string : recollectable.getRecollectablesNames()) {
                tooltip.add(new TextComponentTranslation(string, new Object[0]).func_150254_d());
            }
        }
        return tooltip;
    }
}

