/*
 * Decompiled with CFR 0.152.
 */
package iguanaman.hungeroverhaul.module;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import iguanaman.hungeroverhaul.config.IguanaConfig;
import iguanaman.hungeroverhaul.util.BonemealModification;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraftforge.event.entity.player.BonemealEvent;

public class ModuleBonemeal {
    private static HashMap<Class<? extends Block>, BonemealModification> bonemealModificationsByBlockClass = new HashMap();
    private static HashMap<Block, BonemealModification> bonemealModificationsByBlock = new HashMap();

    public static void registerBonemealModifier(Class<? extends Block> blockClass, BonemealModification bonemealModification) {
        bonemealModificationsByBlockClass.put(blockClass, bonemealModification);
    }

    public static void registerBonemealModifier(Block block, BonemealModification bonemealModification) {
        bonemealModificationsByBlock.put(block, bonemealModification);
    }

    public static BonemealModification getBonemealModification(Block block) {
        BonemealModification bonemealModification = bonemealModificationsByBlock.get(block);
        if (bonemealModification != null) {
            return bonemealModification;
        }
        return ModuleBonemeal.getBonemealModification(block.getClass());
    }

    public static BonemealModification getBonemealModification(Class<? extends Block> blockClass) {
        BonemealModification bonemealModification = bonemealModificationsByBlockClass.get(blockClass);
        if (bonemealModification == null) {
            for (Map.Entry<Class<? extends Block>, BonemealModification> entry : bonemealModificationsByBlockClass.entrySet()) {
                if (!entry.getKey().isInstance(blockClass)) continue;
                return entry.getValue();
            }
        }
        return bonemealModification;
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onBonemealUsed(BonemealEvent event) {
        if (event.world.field_72995_K) {
            return;
        }
        if (event.getResult() != Event.Result.DEFAULT || event.isCanceled() || IguanaConfig.bonemealEffectiveness == 1.0f) {
            return;
        }
        BonemealModification bonemealModification = ModuleBonemeal.getBonemealModification(event.block);
        if (bonemealModification == null) {
            return;
        }
        if (IguanaConfig.bonemealEffectiveness == 0.0f) {
            event.setCanceled(true);
            event.setResult(Event.Result.DENY);
            return;
        }
        if (event.world.field_73012_v.nextFloat() < IguanaConfig.bonemealEffectiveness) {
            if (IguanaConfig.modifyBonemealGrowth) {
                int resultingMeta;
                int meta = event.world.func_72805_g(event.x, event.y, event.z);
                if (meta != (resultingMeta = bonemealModification.getNewMeta(event.world, event.x, event.y, event.z, event.block, meta))) {
                    event.world.func_72921_c(event.x, event.y, event.z, resultingMeta, 3);
                }
                bonemealModification.onBonemeal(event.world, event.x, event.y, event.z, event.block, resultingMeta);
                event.setResult(Event.Result.ALLOW);
            }
        } else {
            event.setResult(Event.Result.ALLOW);
        }
    }
}

