/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.headcrumbs.utils.helpers;

import cpw.mods.fml.common.Loader;
import ganymedes01.headcrumbs.libs.SkullTypes;
import ganymedes01.headcrumbs.utils.helpers.VanillaHelper;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.item.ItemStack;

public abstract class HeadDropHelper
implements Comparable<HeadDropHelper> {
    public static final List<HeadDropHelper> helpers = new LinkedList<HeadDropHelper>();
    protected final String modID;
    protected final Map<String, SkullTypes> typesMap = new HashMap<String, SkullTypes>();

    public static ItemStack getHead(Entity entity) {
        for (HeadDropHelper helper : helpers) {
            ItemStack head;
            if (!helper.isEnabled() || (head = helper.getHeadForEntity(entity)) == null) continue;
            return head;
        }
        return null;
    }

    public static void register(HeadDropHelper helper) {
        helpers.add(helper);
        Collections.sort(helpers);
    }

    public HeadDropHelper(String modID) {
        this.modID = modID;
    }

    protected boolean isEnabled() {
        return Loader.isModLoaded((String)this.modID);
    }

    protected ItemStack getHeadForEntity(Entity entity) {
        String mobName = EntityList.func_75621_b((Entity)entity);
        if (mobName == null) {
            return null;
        }
        SkullTypes type = this.typesMap.get(mobName);
        if (type != null) {
            return type.getStack();
        }
        return null;
    }

    @Override
    public int compareTo(HeadDropHelper obj) {
        return obj instanceof VanillaHelper ? -1 : 0;
    }
}

