/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.rice.init;

import cpw.mods.fml.common.registry.GameRegistry;
import growthcraft.api.cellar.booze.Booze;
import growthcraft.api.cellar.booze.BoozeTag;
import growthcraft.api.cellar.common.Residue;
import growthcraft.api.core.effect.EffectAddPotionEffect;
import growthcraft.api.core.effect.EffectWeightedRandomList;
import growthcraft.api.core.effect.SimplePotionEffectFactory;
import growthcraft.api.core.item.OreItemStacks;
import growthcraft.api.core.util.TickUtils;
import growthcraft.cellar.GrowthCraftCellar;
import growthcraft.cellar.common.block.BlockFluidBooze;
import growthcraft.cellar.common.definition.BlockBoozeDefinition;
import growthcraft.cellar.common.definition.ItemBucketBoozeDefinition;
import growthcraft.cellar.common.item.EnumYeast;
import growthcraft.cellar.common.item.ItemBoozeBottle;
import growthcraft.cellar.util.BoozeRegistryHelper;
import growthcraft.cellar.util.BoozeUtils;
import growthcraft.core.GrowthCraftCore;
import growthcraft.core.common.GrcModuleBase;
import growthcraft.core.common.definition.ItemDefinition;
import growthcraft.rice.GrowthCraftRice;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class GrcRiceFluids
extends GrcModuleBase {
    public Booze[] riceSakeBooze;
    public BlockBoozeDefinition[] riceSakeFluids;
    public ItemDefinition riceSake;
    public ItemBucketBoozeDefinition[] riceSakeBuckets;

    @Override
    public void preInit() {
        this.riceSakeBooze = new Booze[7];
        this.riceSakeFluids = new BlockBoozeDefinition[this.riceSakeBooze.length];
        this.riceSakeBuckets = new ItemBucketBoozeDefinition[this.riceSakeBooze.length];
        BoozeRegistryHelper.initializeBoozeFluids("grc.riceSake", this.riceSakeBooze);
        for (Booze booze : this.riceSakeBooze) {
            booze.setColor(GrowthCraftRice.getConfig().riceSakeColor).setDensity(980);
        }
        BoozeRegistryHelper.initializeBooze(this.riceSakeBooze, this.riceSakeFluids, this.riceSakeBuckets);
        BoozeRegistryHelper.setBoozeFoodStats(this.riceSakeBooze, 1, -0.6f);
        BoozeRegistryHelper.setBoozeFoodStats(this.riceSakeBooze[0], 1, 0.2f);
        this.riceSakeBooze[4].setColor(GrowthCraftRice.getConfig().riceSakeDivineColor);
        ((BlockFluidBooze)((Object)this.riceSakeFluids[4].getBlock())).refreshColor();
        this.riceSake = GrowthCraftRice.items.newDefinition((Item)new ItemBoozeBottle(this.riceSakeBooze));
    }

    private void registerRecipes() {
        int fermentTime = GrowthCraftCellar.getConfig().fermentTime;
        FluidStack[] fs = new FluidStack[this.riceSakeBooze.length];
        for (int i = 0; i < fs.length; ++i) {
            fs[i] = new FluidStack((Fluid)this.riceSakeBooze[i], 1);
        }
        GrowthCraftCellar.boozeBuilderFactory.create(this.riceSakeBooze[0]).tags(BoozeTag.YOUNG).brewsFrom(new FluidStack(FluidRegistry.WATER, 40), new OreItemStacks("cropRice"), TickUtils.minutes(1), Residue.newDefault(0.2f));
        GrowthCraftCellar.boozeBuilderFactory.create(this.riceSakeBooze[1]).tags(BoozeTag.FERMENTED).fermentsFrom(fs[0], EnumYeast.BREWERS.asStack(), fermentTime).fermentsFrom(fs[0], new ItemStack(Items.field_151075_bm), (int)((double)fermentTime * 0.66)).getEffect().setTipsy(BoozeUtils.alcoholToTipsy(0.15f), TickUtils.seconds(45)).addPotionEntry(Potion.field_76430_j, TickUtils.minutes(3), 0);
        GrowthCraftCellar.boozeBuilderFactory.create(this.riceSakeBooze[2]).tags(BoozeTag.FERMENTED, BoozeTag.POTENT).fermentsFrom(fs[1], new OreItemStacks("dustGlowstone"), fermentTime).fermentsFrom(fs[3], new OreItemStacks("dustGlowstone"), fermentTime).getEffect().setTipsy(BoozeUtils.alcoholToTipsy(0.17f), TickUtils.seconds(45)).addPotionEntry(Potion.field_76430_j, TickUtils.minutes(3), 0);
        GrowthCraftCellar.boozeBuilderFactory.create(this.riceSakeBooze[3]).tags(BoozeTag.FERMENTED, BoozeTag.EXTENDED).fermentsFrom(fs[1], new OreItemStacks("dustRedstone"), fermentTime).fermentsFrom(fs[2], new OreItemStacks("dustRedstone"), fermentTime).getEffect().setTipsy(BoozeUtils.alcoholToTipsy(0.15f), TickUtils.seconds(45)).addPotionEntry(Potion.field_76430_j, TickUtils.minutes(3), 0);
        GrowthCraftCellar.boozeBuilderFactory.create(this.riceSakeBooze[4]).tags(BoozeTag.FERMENTED, BoozeTag.HYPER_EXTENDED).fermentsFrom(fs[2], EnumYeast.ETHEREAL.asStack(), fermentTime).fermentsFrom(fs[3], EnumYeast.ETHEREAL.asStack(), fermentTime).getEffect().setTipsy(BoozeUtils.alcoholToTipsy(0.15f), TickUtils.seconds(45)).addPotionEntry(Potion.field_76430_j, TickUtils.minutes(3), 0).addPotionEntry(Potion.field_76424_c, TickUtils.minutes(3), 0);
        GrowthCraftCellar.boozeBuilderFactory.create(this.riceSakeBooze[5]).tags(BoozeTag.FERMENTED, BoozeTag.INTOXICATED).fermentsFrom(fs[2], EnumYeast.ORIGIN.asStack(), fermentTime).fermentsFrom(fs[3], EnumYeast.ORIGIN.asStack(), fermentTime).getEffect().setTipsy(BoozeUtils.alcoholToTipsy(0.2f), TickUtils.seconds(45)).addEffect(new EffectWeightedRandomList().add(8, new EffectAddPotionEffect(new SimplePotionEffectFactory(Potion.field_76430_j.field_76415_H, TickUtils.minutes(3), 2))).add(2, new EffectAddPotionEffect(new SimplePotionEffectFactory(Potion.field_76431_k.field_76415_H, TickUtils.minutes(3), 2))));
        GrowthCraftCellar.boozeBuilderFactory.create(this.riceSakeBooze[6]).tags(BoozeTag.FERMENTED, BoozeTag.POISONED).getEffect().setTipsy(BoozeUtils.alcoholToTipsy(0.15f), TickUtils.seconds(45)).createPotionEntry(Potion.field_76436_u, TickUtils.seconds(90), 0).toggleDescription(!GrowthCraftCore.getConfig().hidePoisonedBooze);
    }

    @Override
    public void register() {
        GameRegistry.registerItem(this.riceSake.getItem(), (String)"grc.riceSake");
        BoozeRegistryHelper.registerBooze(this.riceSakeBooze, this.riceSakeFluids, this.riceSakeBuckets, this.riceSake, "grc.riceSake", null);
        this.registerRecipes();
    }
}

