/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.milk.common.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import growthcraft.api.core.nbt.INBTItemSerializable;
import growthcraft.api.core.util.FXHelper;
import growthcraft.api.core.util.Pair;
import growthcraft.api.core.util.PulseStepper;
import growthcraft.api.core.util.SpatialRandom;
import growthcraft.api.core.util.TickUtils;
import growthcraft.core.common.tileentity.GrcTileBase;
import growthcraft.core.common.tileentity.event.TileEventHandler;
import growthcraft.milk.GrowthCraftMilk;
import growthcraft.milk.common.item.ItemBlockHangingCurds;
import growthcraft.milk.common.struct.CheeseCurd;
import growthcraft.milk.common.tileentity.IPancheonTile;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public class TileEntityHangingCurds
extends GrcTileBase
implements INBTItemSerializable {
    private SpatialRandom sprand = new SpatialRandom();
    private PulseStepper wheyPulsar = new PulseStepper(TickUtils.seconds(15), 10);
    private PulseStepper animPulsar = new PulseStepper(10, 4);
    private int serverStep;
    @SideOnly(value=Side.CLIENT)
    private int clientStep;
    private CheeseCurd cheeseCurd = new CheeseCurd();

    private IPancheonTile getPancheonTile() {
        for (int i = 1; i < 3; ++i) {
            TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - i, this.field_145849_e);
            if (te instanceof IPancheonTile) {
                return (IPancheonTile)te;
            }
            if (!this.field_145850_b.func_147437_c(this.field_145851_c, this.field_145848_d - i, this.field_145849_e)) break;
        }
        return null;
    }

    public int getRenderColor() {
        return this.cheeseCurd.getRenderColor();
    }

    public float getProgress() {
        return this.cheeseCurd.getAgeProgress();
    }

    public boolean isDried() {
        return this.cheeseCurd.isDried();
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            if (this.cheeseCurd.needClientUpdate) {
                this.cheeseCurd.needClientUpdate = false;
                this.markForUpdate();
            }
            this.cheeseCurd.update();
            if (this.wheyPulsar.update() == PulseStepper.State.PULSE) {
                FluidStack stack;
                IPancheonTile pancheonTile = this.getPancheonTile();
                if (pancheonTile != null && pancheonTile.canFill(ForgeDirection.UP, (stack = GrowthCraftMilk.fluids.whey.fluid.asFluidStack(100)).getFluid())) {
                    pancheonTile.fill(ForgeDirection.UP, stack, true);
                }
                ++this.serverStep;
                this.markDirtyAndUpdate();
            }
        } else {
            if (this.clientStep != this.serverStep) {
                this.clientStep = this.serverStep;
                this.animPulsar.reset();
            }
            if (this.animPulsar.update() == PulseStepper.State.PULSE) {
                Pair<Double, Double> p = this.sprand.nextCenteredD2();
                double px = (double)this.field_145851_c + 0.5 + (Double)p.left * 0.5;
                double py = this.field_145848_d;
                double pz = (double)this.field_145849_e + 0.5 + (Double)p.right * 0.5;
                FXHelper.dropParticle(this.field_145850_b, px, py, pz, GrowthCraftMilk.fluids.whey.getItemColor());
            }
        }
    }

    protected void readCheeseCurdFromNBT(NBTTagCompound nbt) {
        this.cheeseCurd.readFromNBT(nbt);
    }

    protected void readWheyPulsarFromNBT(NBTTagCompound nbt) {
        this.wheyPulsar.readFromNBT(nbt, "whey_pulsar");
    }

    @Override
    public void readFromNBTForItem(NBTTagCompound nbt) {
        super.readFromNBTForItem(nbt);
        this.readCheeseCurdFromNBT(nbt);
        this.readWheyPulsarFromNBT(nbt);
    }

    @TileEventHandler(event=TileEventHandler.EventType.NBT_READ)
    public void readFromNBT_HangingCurds(NBTTagCompound nbt) {
        this.readCheeseCurdFromNBT(nbt);
        this.readWheyPulsarFromNBT(nbt);
    }

    protected void writeCheeseCurdToNBT(NBTTagCompound nbt) {
        this.cheeseCurd.writeToNBT(nbt);
    }

    protected void writeWheyPulsarToNBT(NBTTagCompound nbt) {
        this.wheyPulsar.writeToNBT(nbt, "whey_pulsar");
    }

    @Override
    public void writeToNBTForItem(NBTTagCompound nbt) {
        super.writeToNBTForItem(nbt);
        this.writeCheeseCurdToNBT(nbt);
        this.writeWheyPulsarToNBT(nbt);
    }

    @TileEventHandler(event=TileEventHandler.EventType.NBT_WRITE)
    public void writeToNBT_HangingCurds(NBTTagCompound nbt) {
        this.writeCheeseCurdToNBT(nbt);
        this.writeWheyPulsarToNBT(nbt);
    }

    @TileEventHandler(event=TileEventHandler.EventType.NETWORK_READ)
    public boolean readFromStream_HangingCurds(ByteBuf stream) throws IOException {
        this.cheeseCurd.readFromStream(stream);
        this.wheyPulsar.readFromStream(stream);
        this.serverStep = stream.readInt();
        return true;
    }

    @TileEventHandler(event=TileEventHandler.EventType.NETWORK_WRITE)
    public boolean writeToStream_HangingCurds(ByteBuf stream) throws IOException {
        this.cheeseCurd.writeToStream(stream);
        this.wheyPulsar.writeToStream(stream);
        stream.writeInt(this.serverStep);
        return true;
    }

    public ItemStack asItemStack() {
        ItemStack stack = GrowthCraftMilk.blocks.hangingCurds.asStack();
        NBTTagCompound tag = ItemBlockHangingCurds.openNBT(stack);
        this.writeToNBTForItem(tag);
        return stack;
    }
}

