/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.milk.common.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import growthcraft.api.core.i18n.GrcI18n;
import growthcraft.api.core.nbt.NBTHelper;
import growthcraft.core.common.item.IItemTileBlock;
import growthcraft.milk.common.item.EnumCheeseType;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class ItemBlockHangingCurds
extends ItemBlock
implements IItemTileBlock {
    public ItemBlockHangingCurds(Block block) {
        super(block);
        this.func_77627_a(true);
    }

    private NBTTagCompound getTileTagCompoundABS(ItemStack stack) {
        NBTTagCompound tag = NBTHelper.openItemStackTag(stack);
        if (!tag.func_74764_b("te_curd_block")) {
            NBTTagCompound curdTag = new NBTTagCompound();
            EnumCheeseType cheeseType = EnumCheeseType.getSafeById(stack.func_77960_j());
            cheeseType.writeToNBT(curdTag);
            tag.func_74782_a("te_curd_block", (NBTBase)curdTag);
        }
        return tag.func_74775_l("te_curd_block");
    }

    public EnumCheeseType getCheeseType(ItemStack stack) {
        NBTTagCompound tag = this.getTileTagCompoundABS(stack);
        return EnumCheeseType.loadFromNBT(tag);
    }

    @Override
    public void setTileTagCompound(ItemStack stack, NBTTagCompound tileTag) {
        NBTTagCompound tag = NBTHelper.openItemStackTag(stack);
        tag.func_74782_a("te_curd_block", (NBTBase)tileTag);
    }

    @Override
    public NBTTagCompound getTileTagCompound(ItemStack stack) {
        NBTTagCompound tag = this.getTileTagCompoundABS(stack);
        EnumCheeseType type = this.getCheeseType(stack);
        if (stack.func_77960_j() != type.meta) {
            stack.func_77964_b(type.meta);
        }
        return tag;
    }

    public boolean isDried(ItemStack stack) {
        NBTTagCompound nbt = this.getTileTagCompound(stack);
        if (nbt.func_74764_b("dried")) {
            return nbt.func_74767_n("dried");
        }
        return false;
    }

    public String func_77667_c(ItemStack stack) {
        String str = super.func_77667_c(stack);
        str = str + "." + this.getCheeseType((ItemStack)stack).name;
        if (this.isDried(stack)) {
            str = str + ".dried";
        }
        return str;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean bool) {
        NBTTagCompound nbt = this.getTileTagCompound(stack);
        if (nbt.func_74764_b("dried") && nbt.func_74767_n("dried")) {
            list.add(GrcI18n.translate("grcmilk.hanging_curds.dried"));
        } else {
            int age = nbt.func_74762_e("age");
            if (age > 0) {
                int ageMax = nbt.func_74762_e("age_max");
                int t = age * 100 / (ageMax > 0 ? ageMax : 1200);
                list.add(GrcI18n.translate("grcmilk.hanging_curds.drying.prefix") + GrcI18n.translate("grcmilk.hanging_curds.drying.progress.format", t));
            }
        }
        super.func_77624_a(stack, player, list, bool);
    }

    public static NBTTagCompound openNBT(ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item instanceof ItemBlockHangingCurds) {
            return ((ItemBlockHangingCurds)item).getTileTagCompound(stack);
        }
        return null;
    }
}

