/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.grapes;

import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.VillagerRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import growthcraft.api.core.CoreRegistry;
import growthcraft.api.core.log.GrcLogger;
import growthcraft.api.core.log.ILogger;
import growthcraft.api.core.module.ModuleContainer;
import growthcraft.cellar.GrowthCraftCellar;
import growthcraft.core.GrowthCraftCore;
import growthcraft.core.integration.NEI;
import growthcraft.core.util.MapGenHelper;
import growthcraft.grapes.GrcGrapesConfig;
import growthcraft.grapes.common.CommonProxy;
import growthcraft.grapes.common.village.ComponentVillageGrapeVineyard;
import growthcraft.grapes.common.village.VillageHandlerGrapes;
import growthcraft.grapes.creativetab.CreativeTabsGrowthcraftGrapes;
import growthcraft.grapes.event.BonemealEventGrapes;
import growthcraft.grapes.init.GrcGrapesBlocks;
import growthcraft.grapes.init.GrcGrapesFluids;
import growthcraft.grapes.init.GrcGrapesItems;
import growthcraft.grapes.integration.ForestryModule;
import growthcraft.grapes.integration.MFRModule;
import growthcraft.grapes.integration.ThaumcraftModule;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.oredict.OreDictionary;

@Mod(modid="Growthcraft|Grapes", name="Growthcraft Grapes", version="1.7.10-2.7.2", dependencies="required-after:Growthcraft@1.7.10-2.7.2;required-after:Growthcraft|Cellar@1.7.10-2.7.2")
public class GrowthCraftGrapes {
    public static final String MOD_ID = "Growthcraft|Grapes";
    public static final String MOD_NAME = "Growthcraft Grapes";
    public static final String MOD_VERSION = "1.7.10-2.7.2";
    @Mod.Instance(value="Growthcraft|Grapes")
    public static GrowthCraftGrapes instance;
    public static CreativeTabs creativeTab;
    public static final GrcGrapesBlocks blocks;
    public static final GrcGrapesItems items;
    public static final GrcGrapesFluids fluids;
    private final ILogger logger = new GrcLogger("Growthcraft|Grapes");
    private final GrcGrapesConfig config = new GrcGrapesConfig();
    private final ModuleContainer modules = new ModuleContainer();

    public static GrcGrapesConfig getConfig() {
        return GrowthCraftGrapes.instance.config;
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.config.setLogger(this.logger);
        this.config.load(event.getModConfigurationDirectory(), "growthcraft/grapes.conf");
        this.modules.add(blocks);
        this.modules.add(items);
        this.modules.add(fluids);
        if (this.config.enableForestryIntegration) {
            this.modules.add(new ForestryModule());
        }
        if (this.config.enableMFRIntegration) {
            this.modules.add(new MFRModule());
        }
        if (this.config.enableThaumcraftIntegration) {
            this.modules.add(new ThaumcraftModule());
        }
        this.modules.add(CommonProxy.instance);
        if (this.config.debugEnabled) {
            this.modules.setLogger(this.logger);
        }
        this.modules.freeze();
        creativeTab = new CreativeTabsGrowthcraftGrapes("creative_tab_grcgrapes");
        this.modules.preInit();
        this.register();
        GrowthCraftGrapes.blocks.grapeVine1.getBlock().setItemDrop(GrowthCraftGrapes.items.grapeSeeds.asStack(1));
    }

    private void register() {
        this.modules.register();
        CoreRegistry.instance().vineDrops().addDropEntry(GrowthCraftGrapes.items.grapes.asStack(), this.config.vineGrapeDropRarity);
        MapGenHelper.registerVillageStructure(ComponentVillageGrapeVineyard.class, "grc.grapevineyard");
        Blocks.field_150480_ab.setFireInfo((Block)GrowthCraftGrapes.blocks.grapeLeaves.getBlock(), 30, 60);
        OreDictionary.registerOre((String)"cropGrapes", GrowthCraftGrapes.items.grapes.getItem());
        OreDictionary.registerOre((String)"foodGrapes", GrowthCraftGrapes.items.grapes.getItem());
        OreDictionary.registerOre((String)"seedGrapes", GrowthCraftGrapes.items.grapeSeeds.getItem());
        OreDictionary.registerOre((String)"cropGrape", GrowthCraftGrapes.items.grapes.getItem());
        OreDictionary.registerOre((String)"seedGrape", GrowthCraftGrapes.items.grapeSeeds.getItem());
        OreDictionary.registerOre((String)"listAllseed", GrowthCraftGrapes.items.grapeSeeds.getItem());
        OreDictionary.registerOre((String)"listAllfruit", GrowthCraftGrapes.items.grapes.getItem());
        OreDictionary.registerOre((String)"foodFruit", GrowthCraftGrapes.items.grapes.getItem());
        GameRegistry.addShapelessRecipe((ItemStack)GrowthCraftGrapes.items.grapeSeeds.asStack(), (Object[])new Object[]{GrowthCraftGrapes.items.grapes.getItem()});
        NEI.hideItem(GrowthCraftGrapes.blocks.grapeVine0.asStack());
        NEI.hideItem(GrowthCraftGrapes.blocks.grapeVine1.asStack());
        NEI.hideItem(GrowthCraftGrapes.blocks.grapeBlock.asStack());
        NEI.hideItem(GrowthCraftGrapes.blocks.grapeLeaves.asStack());
    }

    private void initVillageHandlers() {
        VillageHandlerGrapes handler = new VillageHandlerGrapes();
        int brewerID = GrowthCraftCellar.getConfig().villagerBrewerID;
        if (brewerID > 0) {
            VillagerRegistry.instance().registerVillageTradeHandler(brewerID, (VillagerRegistry.IVillageTradeHandler)handler);
        }
        VillagerRegistry.instance().registerVillageCreationHandler((VillagerRegistry.IVillageCreationHandler)handler);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        ChestGenHooks.getInfo((String)"strongholdCorridor").addItem(new WeightedRandomChestContent(GrowthCraftGrapes.items.grapes.asStack(), 1, 2, 10));
        ChestGenHooks.getInfo((String)"strongholdCrossing").addItem(new WeightedRandomChestContent(GrowthCraftGrapes.items.grapes.asStack(), 1, 2, 10));
        if (this.config.enableVillageGen) {
            this.initVillageHandlers();
        }
        this.modules.init();
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onTextureStitchPost(TextureStitchEvent.Post event) {
        if (event.map.func_130086_a() == 0) {
            for (int i = 0; i < GrowthCraftGrapes.fluids.grapeWineBooze.length; ++i) {
                GrowthCraftGrapes.fluids.grapeWineBooze[i].setIcons(GrowthCraftCore.liquidSmoothTexture);
            }
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new BonemealEventGrapes());
        this.modules.postInit();
    }

    static {
        blocks = new GrcGrapesBlocks();
        items = new GrcGrapesItems();
        fluids = new GrcGrapesFluids();
    }
}

