/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core.eventhandler;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import growthcraft.core.GrowthCraftCore;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.FillBucketEvent;

public class EventHandlerBucketFill {
    private static EventHandlerBucketFill INSTANCE = new EventHandlerBucketFill();
    private List<IBucketEntry> buckets = new ArrayList<IBucketEntry>();

    public static EventHandlerBucketFill instance() {
        return INSTANCE;
    }

    public void addEntry(@Nonnull IBucketEntry entry) {
        this.buckets.add(entry);
        GrowthCraftCore.getLogger().debug("Added new Bucket Entry {%s}", entry);
    }

    public EventHandlerBucketFill register(Block block, ItemStack stack) {
        this.addEntry(new GenericBucketEntry(block, stack));
        return this;
    }

    public EventHandlerBucketFill register(Block block, Item item) {
        return this.register(block, new ItemStack(item, 1));
    }

    private ItemStack fillCustomBucket(FillBucketEvent event) {
        for (IBucketEntry entry : this.buckets) {
            if (!entry.matches(event.world, event.target)) continue;
            entry.commit(event.entityPlayer, event.world, event.target);
            return entry.getItemStack();
        }
        return null;
    }

    @SubscribeEvent
    public void onBucketFill(FillBucketEvent event) {
        if (event.world.field_72995_K || event.result != null || event.getResult() != Event.Result.DEFAULT) {
            return;
        }
        ItemStack result = this.fillCustomBucket(event);
        if (result != null) {
            event.result = result.func_77946_l();
            event.setResult(Event.Result.ALLOW);
        }
    }

    public static class GenericBucketEntry
    implements IBucketEntry {
        private final Block block;
        private final ItemStack itemStack;

        public GenericBucketEntry(Block blk, ItemStack stack) {
            this.block = blk;
            this.itemStack = stack;
        }

        @Override
        public ItemStack getItemStack() {
            return this.itemStack;
        }

        @Override
        public boolean matches(@Nonnull World world, @Nonnull MovingObjectPosition pos) {
            Block srcBlock = world.func_147439_a(pos.field_72311_b, pos.field_72312_c, pos.field_72309_d);
            if (this.block.equals(srcBlock)) {
                return world.func_72805_g(pos.field_72311_b, pos.field_72312_c, pos.field_72309_d) == 0;
            }
            return false;
        }

        @Override
        public void commit(@Nonnull EntityPlayer player, @Nonnull World world, @Nonnull MovingObjectPosition pos) {
            world.func_147468_f(pos.field_72311_b, pos.field_72312_c, pos.field_72309_d);
        }

        public String toString() {
            return String.format("GenericBucketEntry{ block: {%s}, item_stack: {%s} }", this.block, this.itemStack);
        }
    }

    public static interface IBucketEntry {
        public ItemStack getItemStack();

        public boolean matches(@Nonnull World var1, @Nonnull MovingObjectPosition var2);

        public void commit(@Nonnull EntityPlayer var1, @Nonnull World var2, @Nonnull MovingObjectPosition var3);
    }
}

