/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core.common.tileentity.event;

import growthcraft.core.common.tileentity.event.TileEventFunction;
import growthcraft.core.common.tileentity.event.TileEventFunctionMap;
import growthcraft.core.common.tileentity.event.TileEventHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.tileentity.TileEntity;

public class TileEventHandlerMap<T extends TileEntity>
extends HashMap<Class<? extends T>, TileEventFunctionMap> {
    public static final long serialVersionUID = 1L;

    protected void addHandlerEventFunction(@Nonnull TileEventFunctionMap handlerMap, @Nonnull TileEventHandler.EventType type, @Nonnull Method method) {
        if (!handlerMap.containsKey((Object)type)) {
            handlerMap.put(type, new ArrayList());
        }
        ((List)handlerMap.get((Object)type)).add(new TileEventFunction(method));
    }

    public TileEventFunctionMap getEventFunctionMap(Class<? extends T> klass) {
        TileEventFunctionMap cached = (TileEventFunctionMap)this.get(klass);
        if (cached == null) {
            cached = new TileEventFunctionMap();
            this.put(klass, cached);
            for (Method method : klass.getMethods()) {
                TileEventHandler anno = method.getAnnotation(TileEventHandler.class);
                if (anno == null) continue;
                this.addHandlerEventFunction(cached, anno.event(), method);
            }
        }
        return cached;
    }

    public List<TileEventFunction> getEventFunctionsForClass(Class<? extends T> klass, TileEventHandler.EventType type) {
        return (List)this.getEventFunctionMap(klass).get((Object)type);
    }
}

