/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core.common.tileentity;

import growthcraft.core.common.inventory.GrcInternalInventory;
import growthcraft.core.common.inventory.IInventoryWatcher;
import growthcraft.core.common.inventory.InventoryProcessor;
import growthcraft.core.common.tileentity.GrcTileBase;
import growthcraft.core.common.tileentity.event.TileEventHandler;
import growthcraft.core.common.tileentity.feature.ICustomDisplayName;
import growthcraft.core.util.ItemUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public abstract class GrcTileInventoryBase
extends GrcTileBase
implements ISidedInventory,
ICustomDisplayName,
IInventoryWatcher {
    protected static final int[] NO_SLOTS = new int[0];
    protected String inventoryName;
    protected GrcInternalInventory inventory = this.createInventory();

    public GrcInternalInventory createInventory() {
        return new GrcInternalInventory(this, 0);
    }

    public GrcInternalInventory getInternalInventory() {
        return this.inventory;
    }

    public String getDefaultInventoryName() {
        return "grc.inventory.name";
    }

    @Override
    public void onInventoryChanged(IInventory inv, int index) {
        this.func_70296_d();
    }

    @Override
    public void onItemDiscarded(IInventory inv, ItemStack stack, int index, int discardedAmount) {
        ItemStack discarded = stack.func_77946_l();
        discarded.field_77994_a = discardedAmount;
        ItemUtils.spawnItemStack(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, discarded, this.field_145850_b.field_73012_v);
    }

    public String func_145825_b() {
        return this.func_145818_k_() ? this.inventoryName : this.getDefaultInventoryName();
    }

    public boolean func_145818_k_() {
        return this.inventoryName != null && this.inventoryName.length() > 0;
    }

    @Override
    public void setGuiDisplayName(String string) {
        this.inventoryName = string;
    }

    public ItemStack func_70301_a(int index) {
        return this.inventory.func_70301_a(index);
    }

    public ItemStack tryMergeItemIntoSlot(ItemStack itemstack, int index) {
        ItemStack result = ItemUtils.mergeStacksBang(this.func_70301_a(index), itemstack);
        if (result != null) {
            this.inventory.func_70299_a(index, result);
        }
        return result;
    }

    public ItemStack tryMergeItemIntoMainSlot(ItemStack itemstack) {
        return this.tryMergeItemIntoSlot(itemstack, 0);
    }

    public ItemStack func_70298_a(int index, int par2) {
        return this.inventory.func_70298_a(index, par2);
    }

    public ItemStack func_70304_b(int index) {
        return this.inventory.func_70304_b(index);
    }

    public void func_70299_a(int index, ItemStack itemstack) {
        this.inventory.func_70299_a(index, itemstack);
    }

    public int func_70297_j_() {
        return this.inventory.func_70297_j_();
    }

    public int func_70302_i_() {
        return this.inventory.func_70302_i_();
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack itemstack) {
        return this.inventory.func_94041_b(slot, itemstack);
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return InventoryProcessor.instance().canInsertItem((IInventory)this, stack, slot);
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return InventoryProcessor.instance().canExtractItem((IInventory)this, stack, slot);
    }

    public int[] func_94128_d(int side) {
        return NO_SLOTS;
    }

    protected void readInventoryFromNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b("items")) {
            this.inventory.readFromNBT(nbt, "items");
        } else if (nbt.func_74764_b("inventory")) {
            this.inventory.readFromNBT(nbt, "inventory");
        }
    }

    private void readInventoryNameFromNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b("name")) {
            this.inventoryName = nbt.func_74779_i("name");
        } else if (nbt.func_74764_b("inventory_name")) {
            this.inventoryName = nbt.func_74779_i("inventory_name");
        }
    }

    @Override
    public void readFromNBTForItem(NBTTagCompound nbt) {
        super.readFromNBTForItem(nbt);
        this.readInventoryFromNBT(nbt);
    }

    @TileEventHandler(event=TileEventHandler.EventType.NBT_READ)
    public void readFromNBT_Inventory(NBTTagCompound nbt) {
        this.readInventoryFromNBT(nbt);
        this.readInventoryNameFromNBT(nbt);
    }

    private void writeInventoryToNBT(NBTTagCompound nbt) {
        this.inventory.writeToNBT(nbt, "inventory");
        if (this.func_145818_k_()) {
            nbt.func_74778_a("inventory_name", this.inventoryName);
        }
        nbt.func_74768_a("inventory_tile_version", 3);
    }

    @Override
    public void writeToNBTForItem(NBTTagCompound nbt) {
        super.writeToNBTForItem(nbt);
        this.writeInventoryToNBT(nbt);
    }

    @TileEventHandler(event=TileEventHandler.EventType.NBT_WRITE)
    public void writeToNBT_Inventory(NBTTagCompound nbt) {
        this.writeInventoryToNBT(nbt);
    }
}

