/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import growthcraft.api.core.CoreRegistry;
import growthcraft.api.core.fluids.FluidUtils;
import growthcraft.api.core.fluids.user.UserFluidDictionaryConfig;
import growthcraft.api.core.log.GrcLogger;
import growthcraft.api.core.log.ILogger;
import growthcraft.api.core.module.ModuleContainer;
import growthcraft.api.core.schema.BlockKeySchema;
import growthcraft.api.core.vines.user.UserVinesConfig;
import growthcraft.core.GrcCoreConfig;
import growthcraft.core.common.AchievementPageGrowthcraft;
import growthcraft.core.common.CommonProxy;
import growthcraft.core.common.item.crafting.ShapelessItemComparableRecipe;
import growthcraft.core.creativetab.CreativeTabsGrowthcraft;
import growthcraft.core.eventhandler.EventHandlerBucketFill;
import growthcraft.core.eventhandler.EventHandlerItemCraftedEventCore;
import growthcraft.core.eventhandler.EventHandlerLivingDeathCore;
import growthcraft.core.eventhandler.HarvestDropsEventCore;
import growthcraft.core.eventhandler.PlayerInteractEventPaddy;
import growthcraft.core.eventhandler.TextureStitchEventCore;
import growthcraft.core.init.GrcCoreBlocks;
import growthcraft.core.init.GrcCoreFluids;
import growthcraft.core.init.GrcCoreItems;
import growthcraft.core.init.GrcCoreRecipes;
import growthcraft.core.integration.AppleCore;
import growthcraft.core.integration.ThaumcraftModule;
import growthcraft.core.integration.Waila;
import growthcraft.core.integration.bop.BopPlatform;
import growthcraft.core.stats.GrcCoreAchievements;
import growthcraft.core.util.GameRegistryDumper;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.RecipeSorter;

@Mod(modid="Growthcraft", name="Growthcraft", version="1.7.10-2.7.2", acceptedMinecraftVersions="[1.7.10]", dependencies="required-after:Forge@[10.13.4.1566,);required-after:AppleCore@[1.3.0,);required-after:Forestry@[4.2.8,)")
public class GrowthCraftCore {
    public static final String MOD_ID = "Growthcraft";
    public static final String MOD_NAME = "Growthcraft";
    public static final String MOD_VERSION = "1.7.10-2.7.2";
    public static final String MOD_ACC_MINECRAFT = "[1.7.10]";
    public static final String MOD_DEPENDENCIES = "required-after:Forge@[10.13.4.1566,);required-after:AppleCore@[1.3.0,);required-after:Forestry@[4.2.8,)";
    @Mod.Instance(value="Growthcraft")
    public static GrowthCraftCore instance;
    @SideOnly(value=Side.CLIENT)
    public static IIcon liquidSmoothTexture;
    @SideOnly(value=Side.CLIENT)
    public static IIcon liquidBlobsTexture;
    public static GrcCoreAchievements achievements;
    public static CreativeTabs creativeTab;
    public static final GrcCoreBlocks blocks;
    public static final GrcCoreItems items;
    public static final GrcCoreFluids fluids;
    public static final GrcCoreRecipes recipes;
    public static ItemStack EMPTY_BOTTLE;
    private final ILogger logger = new GrcLogger("Growthcraft");
    private final GrcCoreConfig config = new GrcCoreConfig();
    private final ModuleContainer modules = new ModuleContainer();
    private final UserFluidDictionaryConfig userFluidDictionary = new UserFluidDictionaryConfig();
    private final UserVinesConfig userVinesConfig = new UserVinesConfig();

    public static GrcCoreConfig getConfig() {
        return GrowthCraftCore.instance.config;
    }

    public static ILogger getLogger() {
        return GrowthCraftCore.instance.logger;
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.config.setLogger(this.logger);
        this.config.load(event.getModConfigurationDirectory(), "growthcraft/core.conf");
        if (this.config.debugEnabled) {
            this.logger.info("Pre-Initializing %s", "Growthcraft");
            CoreRegistry.instance().setLogger(this.logger);
        }
        this.modules.add(blocks);
        this.modules.add(items);
        this.modules.add(fluids);
        this.modules.add(recipes);
        this.userVinesConfig.setConfigFile(event.getModConfigurationDirectory(), "growthcraft/core/vines.json");
        this.userFluidDictionary.setConfigFile(event.getModConfigurationDirectory(), "growthcraft/core/fluid_dictionary.json");
        this.modules.add(this.userVinesConfig);
        this.modules.add(this.userFluidDictionary);
        if (this.config.enableThaumcraftIntegration) {
            this.modules.add(new ThaumcraftModule());
        }
        if (this.config.enableWailaIntegration) {
            this.modules.add(new Waila());
        }
        if (this.config.enableAppleCoreIntegration) {
            this.modules.add(new AppleCore());
        }
        this.modules.add(CommonProxy.instance);
        if (this.config.debugEnabled) {
            this.modules.setLogger(this.logger);
        }
        this.modules.freeze();
        creativeTab = new CreativeTabsGrowthcraft("creative_tab_grccore");
        EMPTY_BOTTLE = new ItemStack(Items.field_151069_bo);
        if (this.config.changeWaterBottleCapacity) {
            List<FluidContainerRegistry.FluidContainerData> dataList = FluidUtils.getFluidData().get(FluidRegistry.WATER);
            for (FluidContainerRegistry.FluidContainerData data : dataList) {
                if (!OreDictionary.itemMatches((ItemStack)data.filledContainer, (ItemStack)new ItemStack((Item)Items.field_151068_bn, 1, 0), (boolean)true)) continue;
                data.fluid.amount = this.config.bottleCapacity;
            }
            FluidUtils.getFluidData().clear();
        }
        if (this.config.changeWaterBottleContainer) {
            Items.field_151068_bn.func_77642_a(Items.field_151069_bo);
        }
        RecipeSorter.register((String)"grcShaplessComparable", ShapelessItemComparableRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"");
        this.modules.preInit();
        this.register();
    }

    private void register() {
        MinecraftForge.EVENT_BUS.register((Object)new TextureStitchEventCore());
        this.modules.register();
        achievements = new GrcCoreAchievements();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        this.userFluidDictionary.loadUserConfig();
        AchievementPageGrowthcraft.init();
        this.userVinesConfig.addDefault(Blocks.field_150395_bd);
        if (BopPlatform.isLoaded()) {
            this.userVinesConfig.addDefault(new BlockKeySchema("BiomesOPlenty", "willow", Short.MAX_VALUE));
            this.userVinesConfig.addDefault(new BlockKeySchema("BiomesOPlenty", "ivy", Short.MAX_VALUE));
        }
        this.modules.init();
        this.userVinesConfig.loadUserConfig();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)EventHandlerBucketFill.instance());
        MinecraftForge.EVENT_BUS.register((Object)new HarvestDropsEventCore());
        MinecraftForge.EVENT_BUS.register((Object)new PlayerInteractEventPaddy());
        MinecraftForge.EVENT_BUS.register((Object)new EventHandlerLivingDeathCore());
        FMLCommonHandler.instance().bus().register((Object)new EventHandlerItemCraftedEventCore());
        this.modules.postInit();
        if (this.config.dumpGameRegistry) {
            GameRegistryDumper.run();
        }
    }

    static {
        blocks = new GrcCoreBlocks();
        items = new GrcCoreItems();
        fluids = new GrcCoreFluids();
        recipes = new GrcCoreRecipes();
    }
}

