/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core;

import growthcraft.api.core.util.TagParser;
import growthcraft.core.ConfigBase;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.config.Configuration;

public abstract class ConfigTypeHandler {
    public static List<ConfigTypeHandler> handlers = new ArrayList<ConfigTypeHandler>();

    public abstract boolean canHandle(Field var1);

    public abstract Object handle(Field var1, Configuration var2);

    static {
        handlers.add(new TagHandler());
        handlers.add(new TagTableHandler());
    }

    public static class TagTableHandler
    extends ConfigTypeHandler {
        @Override
        public boolean canHandle(Field field) {
            Class<?> typeClass = field.getType();
            if (typeClass.isArray()) {
                Class<?> componentClass = typeClass.getComponentType();
                return componentClass.isArray() && TagParser.Tag.class.equals(componentClass.getComponentType());
            }
            return false;
        }

        @Override
        public Object handle(Field field, Configuration config) {
            ConfigBase.ConfigOption opt = field.getAnnotation(ConfigBase.ConfigOption.class);
            String value = opt.def();
            String[] rows = TagParser.scsv.parseToArray(config.get(opt.catergory(), opt.name(), value, opt.desc() + "; Default : " + value).getString());
            TagParser.Tag[][] table = new TagParser.Tag[rows.length][];
            int i = 0;
            for (String row : rows) {
                table[i] = TagParser.csv.parse(row);
                ++i;
            }
            return table;
        }
    }

    public static class TagHandler
    extends ConfigTypeHandler {
        @Override
        public boolean canHandle(Field field) {
            Class<?> typeClass = field.getType();
            return typeClass.isArray() && TagParser.Tag.class.equals(typeClass.getComponentType());
        }

        @Override
        public Object handle(Field field, Configuration config) {
            ConfigBase.ConfigOption opt = field.getAnnotation(ConfigBase.ConfigOption.class);
            String value = opt.def();
            TagParser parser = opt.opt().equals("scsv") ? TagParser.scsv : (opt.opt().equals("cosv") ? TagParser.cosv : TagParser.csv);
            return parser.parse(config.get(opt.catergory(), opt.name(), value, opt.desc() + "; Default : " + value).getString());
        }
    }
}

