/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.bees.integration;

import com.google.common.collect.ImmutableMap;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.registry.GameRegistry;
import growthcraft.api.bees.BeesFluidTag;
import growthcraft.api.cellar.booze.BoozeTag;
import growthcraft.api.core.CoreRegistry;
import growthcraft.bees.GrowthCraftBees;
import growthcraft.bees.common.block.BlockBeeBox;
import growthcraft.bees.common.block.BlockBeeBoxForestry;
import growthcraft.bees.common.block.EnumBeeBoxForestry;
import growthcraft.bees.common.item.ItemBlockBeeBox;
import growthcraft.core.common.definition.BlockTypeDefinition;
import growthcraft.core.integration.ForestryModuleBase;
import growthcraft.core.integration.forestry.ForestryFluids;
import growthcraft.core.integration.forestry.ForestryItems;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ForestryModule
extends ForestryModuleBase {
    public ForestryModule() {
        super("Growthcraft|Bees");
    }

    private void maybeAddBee(Item item) {
        if (item != null) {
            GrowthCraftBees.getUserBeesConfig().addDefault(item).setComment("From Forestry");
        }
    }

    @Override
    protected void doPreInit() {
        int beeboxCount = EnumBeeBoxForestry.VALUES.length;
        GrowthCraftBees.blocks.beeBoxesForestry = new ArrayList<BlockTypeDefinition<? extends BlockBeeBox>>();
        GrowthCraftBees.blocks.beeBoxesForestryFireproof = new ArrayList<BlockTypeDefinition<? extends BlockBeeBox>>();
        int i = 0;
        int offset = 0;
        for (EnumBeeBoxForestry[] row : EnumBeeBoxForestry.ROWS) {
            BlockTypeDefinition<BlockBeeBoxForestry> beeBox = GrowthCraftBees.blocks.newTypedDefinition(new BlockBeeBoxForestry(row, offset, i, false));
            BlockTypeDefinition<BlockBeeBoxForestry> beeBoxFP = GrowthCraftBees.blocks.newTypedDefinition(new BlockBeeBoxForestry(row, offset, i, true));
            ((BlockBeeBox)beeBox.getBlock()).setFlammability(20).setFireSpreadSpeed(5).setHarvestLevel("axe", 0);
            ((BlockBeeBox)beeBoxFP.getBlock()).setHarvestLevel("axe", 0);
            GrowthCraftBees.blocks.beeBoxesForestry.add(beeBox);
            GrowthCraftBees.blocks.beeBoxesForestryFireproof.add(beeBoxFP);
            beeBox.register(String.format("grc.BeeBox.Forestry.%d.%s", i, "Normal"), ItemBlockBeeBox.class);
            beeBoxFP.register(String.format("grc.BeeBox.Forestry.%d.%s", i, "Fireproof"), ItemBlockBeeBox.class);
            ++i;
            offset += row.length;
        }
    }

    @Override
    protected void doInit() {
        this.maybeAddBee(GameRegistry.findItem((String)this.modID, (String)"beeQueenGE"));
        this.maybeAddBee(GameRegistry.findItem((String)this.modID, (String)"beeDroneGE"));
        this.maybeAddBee(GameRegistry.findItem((String)this.modID, (String)"beePrincessGE"));
    }

    @Override
    protected void doLateRegister() {
        for (EnumBeeBoxForestry en : EnumBeeBoxForestry.VALUES) {
            BlockTypeDefinition<? extends BlockBeeBox> beeBoxFP;
            ItemStack planks;
            if (en == null) continue;
            BlockTypeDefinition<? extends BlockBeeBox> beeBox = GrowthCraftBees.blocks.beeBoxesForestry.get(en.row);
            if (beeBox != null && (planks = en.getForestryPlanksStack()) != null) {
                GameRegistry.addShapedRecipe((ItemStack)beeBox.asStack(1, en.col), (Object[])new Object[]{" A ", "A A", "AAA", Character.valueOf('A'), planks});
            }
            if ((beeBoxFP = GrowthCraftBees.blocks.beeBoxesForestryFireproof.get(en.row)) == null || (planks = en.getForestryFireproofPlanksStack()) == null) continue;
            GameRegistry.addShapedRecipe((ItemStack)beeBoxFP.asStack(1, en.col), (Object[])new Object[]{" A ", "A A", "AAA", Character.valueOf('A'), planks});
        }
    }

    @Override
    @Optional.Method(modid="Forestry")
    protected void integrate() {
        if (ForestryFluids.SHORT_MEAD.exists()) {
            CoreRegistry.instance().fluidDictionary().addFluidTags(ForestryFluids.SHORT_MEAD.getFluid(), BoozeTag.YOUNG, BeesFluidTag.MEAD);
        }
        ItemStack emptyComb = GrowthCraftBees.items.honeyCombEmpty.asStack();
        ItemStack fullComb = GrowthCraftBees.items.honeyCombFilled.asStack();
        if (ForestryItems.BEESWAX.exists()) {
            this.recipes().centrifugeManager.addRecipe(20, emptyComb, (Map)ImmutableMap.of((Object)ForestryItems.BEESWAX.asStack(), (Object)Float.valueOf(1.0f)));
        }
        if (ForestryItems.BEESWAX.exists() && ForestryItems.HONEY_DROP.exists() && ForestryItems.HONEYDEW.exists()) {
            this.recipes().centrifugeManager.addRecipe(20, fullComb, (Map)ImmutableMap.of((Object)ForestryItems.BEESWAX.asStack(), (Object)Float.valueOf(1.0f), (Object)ForestryItems.HONEY_DROP.asStack(), (Object)Float.valueOf(0.9f), (Object)ForestryItems.HONEYDEW.asStack(), (Object)Float.valueOf(0.1f)));
        }
    }
}

