/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.bees.common.tileentity;

import growthcraft.api.bees.BeesRegistry;
import growthcraft.api.core.item.EnumDye;
import growthcraft.bees.GrowthCraftBees;
import growthcraft.bees.common.inventory.ContainerBeeBox;
import growthcraft.bees.common.tileentity.device.DeviceBeeBox;
import growthcraft.core.common.inventory.GrcInternalInventory;
import growthcraft.core.common.tileentity.GrcTileInventoryBase;
import growthcraft.core.common.tileentity.event.TileEventHandler;
import growthcraft.core.common.tileentity.feature.IInteractionObject;
import growthcraft.core.common.tileentity.feature.IItemHandler;
import growthcraft.core.util.ItemUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class TileEntityBeeBox
extends GrcTileInventoryBase
implements IItemHandler,
IInteractionObject {
    private static final int beeBoxVersion = 3;
    private static final int[] beeSlotIds = new int[]{0};
    private static final int[] honeyCombSlotIds = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27};
    private DeviceBeeBox beeBox = new DeviceBeeBox(this);

    @Override
    public String getGuiID() {
        return "grcbees:bee_box";
    }

    @Override
    public Container createContainer(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new ContainerBeeBox(playerInventory, this);
    }

    @Override
    public void onInventoryChanged(IInventory inv, int index) {
        super.onInventoryChanged(inv, index);
        if (index == 0) {
            this.func_70296_d();
        } else if (index > 0) {
            this.markDirtyAndUpdate();
        }
    }

    @Override
    public String getDefaultInventoryName() {
        return "container.grc.beeBox";
    }

    @Override
    public GrcInternalInventory createInventory() {
        return new GrcInternalInventory(this, 28);
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            this.beeBox.update();
        }
    }

    public void updateBlockTick() {
        if (this.field_145850_b.field_72995_K) {
            this.beeBox.updateClientTick();
        } else {
            this.beeBox.updateTick();
        }
    }

    public boolean hasBonus() {
        return this.beeBox.hasBonus();
    }

    public float getGrowthRate() {
        return this.beeBox.getGrowthRate();
    }

    public void setTime(int v) {
        this.beeBox.setBonusTime(v);
    }

    public boolean slotHasHoneyComb(int index, HoneyCombExpect expects) {
        ItemStack slotItem = this.func_70301_a(index);
        if (slotItem == null) {
            return false;
        }
        switch (expects) {
            case EMPTY: {
                return BeesRegistry.instance().isItemEmptyHoneyComb(slotItem);
            }
            case FILLED: {
                return BeesRegistry.instance().isItemFilledHoneyComb(slotItem);
            }
        }
        return BeesRegistry.instance().isItemHoneyComb(slotItem);
    }

    public boolean slotHasEmptyComb(int index) {
        return this.slotHasHoneyComb(index, HoneyCombExpect.EMPTY);
    }

    public int countCombsOfType(HoneyCombExpect type) {
        int count = 0;
        for (int i = 1; i < this.func_70302_i_(); ++i) {
            if (this.func_70301_a(i) == null || !this.slotHasHoneyComb(i, type)) continue;
            ++count;
        }
        return count;
    }

    public int countHoney() {
        return this.countCombsOfType(HoneyCombExpect.FILLED);
    }

    public int countEmptyCombs() {
        return this.countCombsOfType(HoneyCombExpect.EMPTY);
    }

    public int countCombs() {
        return this.countCombsOfType(HoneyCombExpect.ANY);
    }

    public int getHoneyCombMax() {
        return honeyCombSlotIds.length;
    }

    public int countBees() {
        ItemStack stack = this.func_70301_a(0);
        if (stack == null) {
            return 0;
        }
        return stack.field_77994_a;
    }

    public boolean hasBees() {
        return this.countBees() != 0;
    }

    public boolean hasMaxBees() {
        return this.countBees() >= 64;
    }

    public boolean isHoneyEnough(int size) {
        return this.countHoney() >= size;
    }

    public ItemStack getBeeStack() {
        return this.func_70301_a(0);
    }

    private void setBeeStack(ItemStack itemstack) {
        this.func_70299_a(0, itemstack);
        this.markDirtyAndUpdate();
    }

    public void spawnBee() {
        ItemStack beestack = this.getBeeStack();
        if (beestack == null) {
            this.setBeeStack(GrowthCraftBees.items.bee.asStack());
        } else if (BeesRegistry.instance().isItemBee(beestack)) {
            this.setBeeStack(ItemUtils.increaseStack(beestack));
        }
    }

    public void spawnHoneyCombs(int n) {
        for (int i = 1; i < this.func_70302_i_() && n > 0; ++i) {
            ItemStack stack = this.func_70301_a(i);
            if (stack != null) continue;
            this.func_70299_a(i, GrowthCraftBees.items.honeyCombEmpty.asStack());
            this.markDirtyAndUpdate();
            --n;
        }
    }

    public void spawnHoneyComb() {
        this.spawnHoneyCombs(1);
    }

    public boolean decreaseHoney(int count) {
        boolean shouldMark = false;
        for (int i = 1; i < this.func_70302_i_() && count > 0; ++i) {
            if (!this.slotHasHoneyComb(i, HoneyCombExpect.FILLED)) continue;
            ItemStack stack = this.func_70301_a(i);
            ItemStack result = BeesRegistry.instance().getEmptyHoneyComb(stack);
            this.func_70299_a(i, result != null ? result.func_77946_l() : null);
            --count;
            shouldMark = true;
        }
        if (shouldMark) {
            this.markDirtyAndUpdate();
            return true;
        }
        return false;
    }

    public boolean fillHoneyCombs(int count) {
        boolean shouldMark = false;
        for (int i = 1; i < this.func_70302_i_() && count > 0; ++i) {
            ItemStack stack = this.func_70301_a(i);
            if (stack == null || !this.slotHasEmptyComb(i)) continue;
            ItemStack resultStack = BeesRegistry.instance().getFilledHoneyComb(stack);
            if (resultStack != null) {
                this.func_70299_a(i, resultStack.func_77946_l());
            }
            --count;
            shouldMark = true;
        }
        if (shouldMark) {
            this.markDirtyAndUpdate();
            return true;
        }
        return false;
    }

    public void fillHoneyComb() {
        this.fillHoneyCombs(1);
    }

    @TileEventHandler(event=TileEventHandler.EventType.NBT_READ)
    public void readFromNBT_BeeBox(NBTTagCompound nbt) {
        this.beeBox.readFromNBT(nbt, "bee_box");
        if (nbt.func_74764_b("time")) {
            this.beeBox.setBonusTime(nbt.func_74765_d("time"));
        }
    }

    @TileEventHandler(event=TileEventHandler.EventType.NBT_WRITE)
    public void writeToNBT_BeeBox(NBTTagCompound nbt) {
        nbt.func_74768_a("BeeBox.version", 3);
        this.beeBox.writeToNBT(nbt, "bee_box");
    }

    @Override
    public boolean func_94041_b(int index, ItemStack stack) {
        if (index == 0) {
            return BeesRegistry.instance().isItemBee(stack);
        }
        return BeesRegistry.instance().isItemHoneyComb(stack);
    }

    @Override
    public int[] func_94128_d(int side) {
        return side == 1 ? beeSlotIds : honeyCombSlotIds;
    }

    @Override
    public boolean func_102007_a(int index, ItemStack stack, int side) {
        return this.func_94041_b(index, stack);
    }

    @Override
    public boolean func_102008_b(int index, ItemStack stack, int side) {
        return true;
    }

    @Override
    public boolean tryPlaceItem(IItemHandler.Action action, EntityPlayer player, ItemStack stack) {
        if (IItemHandler.Action.RIGHT != action) {
            return false;
        }
        if (stack != null) {
            Item item = stack.func_77973_b();
            if (item == Items.field_151162_bE) {
                if (this.isHoneyEnough(6)) {
                    ItemUtils.addStackToPlayer(GrowthCraftBees.items.honeyJar.asStack(), player, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, false);
                    ItemUtils.consumeStackOnPlayer(stack, player);
                    this.decreaseHoney(6);
                    return true;
                }
            } else {
                ItemStack result;
                if (item == Items.field_151100_aR) {
                    int time = 0;
                    if (stack.func_77960_j() == EnumDye.PINK.meta) {
                        time = 9600;
                    } else if (stack.func_77960_j() == EnumDye.MAGENTA.meta) {
                        time = 4800;
                    }
                    if (time > 0) {
                        this.setTime(time);
                        this.field_145850_b.func_72926_e(2005, this.field_145851_c, this.field_145848_d, this.field_145849_e, 0);
                        ItemUtils.consumeStackOnPlayer(stack, player);
                        this.markDirtyAndUpdate();
                    }
                    return true;
                }
                if (item == Items.field_151069_bo) {
                    ItemStack result2;
                    if (GrowthCraftBees.fluids.honey != null && this.isHoneyEnough(2) && (result2 = GrowthCraftBees.fluids.honey.asBottleItemStack()) != null) {
                        ItemUtils.addStackToPlayer(result2, player, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, false);
                        ItemUtils.decrPlayerCurrentInventorySlot(player, 1);
                        this.decreaseHoney(2);
                        return true;
                    }
                } else if (item == Items.field_151133_ar && GrowthCraftBees.fluids.honey != null && this.isHoneyEnough(6) && (result = GrowthCraftBees.fluids.honey.asBucketItemStack()) != null) {
                    ItemUtils.addStackToPlayer(result, player, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, false);
                    ItemUtils.decrPlayerCurrentInventorySlot(player, 1);
                    this.decreaseHoney(6);
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean tryTakeItem(IItemHandler.Action action, EntityPlayer player, ItemStack onHand) {
        return false;
    }

    public static enum HoneyCombExpect {
        ANY,
        EMPTY,
        FILLED;

    }
}

