/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.bees.common.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import growthcraft.bees.GrowthCraftBees;
import growthcraft.bees.client.renderer.RenderBeeBox;
import growthcraft.bees.common.tileentity.TileEntityBeeBox;
import growthcraft.core.common.block.GrcBlockContainer;
import growthcraft.core.integration.minecraft.EnumMinecraftWoodType;
import java.util.List;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockBeeBox
extends GrcBlockContainer {
    @SideOnly(value=Side.CLIENT)
    protected IIcon[] icons;
    private int flammability;
    private int fireSpreadSpeed;

    public BlockBeeBox(Material material) {
        super(material);
        this.func_149658_d("grcbees:beebox");
        this.func_149675_a(true);
        this.func_149711_c(2.5f);
        this.func_149672_a(field_149766_f);
        this.func_149663_c("grc.BeeBox.Minecraft");
        this.func_149647_a(GrowthCraftBees.tab);
        this.setTileEntityType(TileEntityBeeBox.class);
    }

    public BlockBeeBox() {
        this(Material.field_151575_d);
    }

    public String getMetaname(int meta) {
        if (meta >= 0 && meta < EnumMinecraftWoodType.VALUES.length) {
            return EnumMinecraftWoodType.VALUES[meta].name;
        }
        return "" + meta;
    }

    public BlockBeeBox setFlammability(int flam) {
        this.flammability = flam;
        return this;
    }

    public BlockBeeBox setFireSpreadSpeed(int speed) {
        this.fireSpreadSpeed = speed;
        return this;
    }

    public int getFlammability(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return this.flammability;
    }

    public int getFireSpreadSpeed(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return this.fireSpreadSpeed;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item block, CreativeTabs tab, List list) {
        for (EnumMinecraftWoodType woodType : EnumMinecraftWoodType.VALUES) {
            list.add(new ItemStack(block, 1, woodType.meta));
        }
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        super.func_149674_a(world, x, y, z, rand);
        TileEntityBeeBox te = (TileEntityBeeBox)this.getTileEntity((IBlockAccess)world, x, y, z);
        if (te != null) {
            te.updateBlockTick();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random random) {
        TileEntityBeeBox te;
        if (random.nextInt(24) == 0 && (te = (TileEntityBeeBox)world.func_147438_o(x, y, z)) != null && te.hasBees()) {
            world.func_72980_b((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), "grcbees:buzz", 1.0f + random.nextFloat(), random.nextFloat() * 0.7f + 0.3f, false);
        }
    }

    @Override
    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int meta, float par7, float par8, float par9) {
        if (super.func_149727_a(world, x, y, z, player, meta, par7, par8, par9)) {
            return true;
        }
        if (world.field_72995_K) {
            return true;
        }
        TileEntityBeeBox te = (TileEntityBeeBox)world.func_147438_o(x, y, z);
        if (te != null) {
            player.openGui((Object)GrowthCraftBees.instance, 0, world, x, y, z);
            return true;
        }
        return false;
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return ForgeDirection.UP == side;
    }

    @Override
    public TileEntity func_149915_a(World world, int par2) {
        return new TileEntityBeeBox();
    }

    public int func_149692_a(int damage) {
        return damage;
    }

    public int func_149745_a(Random random) {
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    protected void registerBeeBoxIcons(IIconRegister reg, String basename, int offset) {
        this.icons[offset * 4] = reg.func_94245_a(this.func_149641_N() + basename + "bottom");
        this.icons[offset * 4 + 1] = reg.func_94245_a(this.func_149641_N() + basename + "top");
        this.icons[offset * 4 + 2] = reg.func_94245_a(this.func_149641_N() + basename + "side");
        this.icons[offset * 4 + 3] = reg.func_94245_a(this.func_149641_N() + basename + "side_honey");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister reg) {
        this.icons = new IIcon[24];
        for (EnumMinecraftWoodType woodType : EnumMinecraftWoodType.VALUES) {
            this.registerBeeBoxIcons(reg, String.format("/minecraft/%s/", woodType.name), woodType.meta);
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected int calculateIconOffset(int meta) {
        return MathHelper.func_76125_a((int)meta, (int)0, (int)(this.icons.length / 4 - 1)) * 4;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        int meta = world.func_72805_g(x, y, z);
        int offset = this.calculateIconOffset(meta);
        if (side == 0) {
            return this.icons[offset];
        }
        if (side == 1) {
            return this.icons[offset + 1];
        }
        TileEntityBeeBox te = (TileEntityBeeBox)world.func_147438_o(x, y, z);
        if (te != null && te.isHoneyEnough(6)) {
            return this.icons[offset + 3];
        }
        return this.icons[offset + 2];
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        int offset = this.calculateIconOffset(meta);
        if (side == 0) {
            return this.icons[offset];
        }
        if (side == 1) {
            return this.icons[offset + 1];
        }
        return this.icons[offset + 2];
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon[] getIcons() {
        return this.icons;
    }

    public int func_149645_b() {
        return RenderBeeBox.id;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149646_a(IBlockAccess world, int x, int y, int z, int side) {
        return true;
    }

    public void func_149683_g() {
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    public void func_149743_a(World world, int x, int y, int z, AxisAlignedBB axis, List list, Entity entity) {
        float f = 0.0625f;
        this.func_149676_a(0.1875f, 0.0f, 0.1875f, 0.3125f, 0.1875f, 0.3125f);
        super.func_149743_a(world, x, y, z, axis, list, entity);
        this.func_149676_a(0.6875f, 0.0f, 0.1875f, 0.8125f, 0.1875f, 0.3125f);
        super.func_149743_a(world, x, y, z, axis, list, entity);
        this.func_149676_a(0.1875f, 0.0f, 0.6875f, 0.3125f, 0.1875f, 0.8125f);
        super.func_149743_a(world, x, y, z, axis, list, entity);
        this.func_149676_a(0.6875f, 0.0f, 0.6875f, 0.8125f, 0.1875f, 0.8125f);
        super.func_149743_a(world, x, y, z, axis, list, entity);
        this.func_149676_a(0.0625f, 0.1875f, 0.0625f, 0.9375f, 0.625f, 0.9375f);
        super.func_149743_a(world, x, y, z, axis, list, entity);
        this.func_149676_a(0.0f, 0.625f, 0.0f, 1.0f, 0.8125f, 1.0f);
        super.func_149743_a(world, x, y, z, axis, list, entity);
        this.func_149676_a(0.125f, 0.8125f, 0.125f, 0.875f, 1.0f, 0.875f);
        super.func_149743_a(world, x, y, z, axis, list, entity);
        this.func_149683_g();
    }

    public boolean func_149740_M() {
        return true;
    }

    public int func_149736_g(World world, int x, int y, int z, int par5) {
        TileEntityBeeBox te = (TileEntityBeeBox)world.func_147438_o(x, y, z);
        if (te != null) {
            return te.countHoney() * 15 / te.getHoneyCombMax();
        }
        return 0;
    }
}

