/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.apples.common.block;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import growthcraft.apples.GrowthCraftApples;
import growthcraft.core.client.renderer.RenderBlockFruit;
import growthcraft.core.common.block.GrcBlockBase;
import growthcraft.core.common.block.ICropDataProvider;
import growthcraft.core.integration.AppleCore;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockApple
extends GrcBlockBase
implements IGrowable,
ICropDataProvider {
    @SideOnly(value=Side.CLIENT)
    private IIcon[] tex;
    private final int growth;
    private final boolean dropRipeApples;
    private final int dropChance;

    public BlockApple() {
        super(Material.field_151585_k);
        this.growth = GrowthCraftApples.getConfig().appleGrowthRate;
        this.dropRipeApples = GrowthCraftApples.getConfig().dropRipeApples;
        this.dropChance = GrowthCraftApples.getConfig().appleDropChance;
        this.func_149675_a(true);
        this.func_149711_c(0.2f);
        this.func_149752_b(5.0f);
        this.func_149672_a(field_149766_f);
        this.func_149663_c("grc.appleBlock");
        this.func_149647_a(null);
    }

    public boolean isMature(IBlockAccess world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        return meta >= 2;
    }

    @Override
    public float getGrowthProgress(IBlockAccess world, int x, int y, int z, int meta) {
        return (float)meta / 2.0f;
    }

    void incrementGrowth(World world, int x, int y, int z, int meta) {
        world.func_72921_c(x, y, z, meta + 1, 2);
        AppleCore.announceGrowthTick(this, world, x, y, z, meta);
    }

    public boolean func_149851_a(World world, int x, int y, int z, boolean isClient) {
        return world.func_72805_g(x, y, z) < 2;
    }

    public boolean func_149852_a(World world, Random random, int x, int y, int z) {
        return true;
    }

    public void func_149853_b(World world, Random random, int x, int y, int z) {
        this.incrementGrowth(world, x, y, z, world.func_72805_g(x, y, z));
    }

    public void func_149674_a(World world, int x, int y, int z, Random random) {
        if (!this.func_149718_j(world, x, y, z)) {
            this.fellBlockAsItem(world, x, y, z);
        } else {
            boolean continueGrowth;
            Event.Result allowGrowthResult = AppleCore.validateGrowthTick(this, world, x, y, z, random);
            if (allowGrowthResult == Event.Result.DENY) {
                return;
            }
            boolean bl = continueGrowth = random.nextInt(this.growth) == 0;
            if (allowGrowthResult == Event.Result.ALLOW || continueGrowth) {
                int meta = world.func_72805_g(x, y, z);
                if (meta < 2) {
                    this.incrementGrowth(world, x, y, z, meta);
                } else if (this.dropRipeApples && world.field_73012_v.nextInt(this.dropChance) == 0) {
                    this.fellBlockAsItem(world, x, y, z);
                }
            }
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int dir, float par7, float par8, float par9) {
        if (world.func_72805_g(x, y, z) >= 2) {
            if (!world.field_72995_K) {
                this.fellBlockAsItem(world, x, y, z);
            }
            return true;
        }
        return false;
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        if (!this.func_149718_j(world, x, y, z)) {
            this.fellBlockAsItem(world, x, y, z);
        }
    }

    public boolean func_149718_j(World world, int x, int y, int z) {
        return GrowthCraftApples.blocks.appleLeaves.equals(world.func_147439_a(x, y + 1, z)) && (world.func_72805_g(x, y + 1, z) & 3) == 0;
    }

    @SideOnly(value=Side.CLIENT)
    public Item func_149694_d(World world, int x, int y, int z) {
        return Items.field_151034_e;
    }

    public Item func_149650_a(int meta, Random random, int par3) {
        return meta >= 2 ? Items.field_151034_e : null;
    }

    public int func_149745_a(Random random) {
        return 1;
    }

    public void func_149690_a(World world, int x, int y, int z, int par5, float par6, int par7) {
        super.func_149690_a(world, x, y, z, par5, par6, 0);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister reg) {
        this.tex = new IIcon[3];
        this.tex[0] = reg.func_94245_a("grcapples:apples_1");
        this.tex[1] = reg.func_94245_a("grcapples:apples_2");
        this.tex[2] = reg.func_94245_a("grcapples:apples_3");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return this.tex[meta];
    }

    public int func_149645_b() {
        return RenderBlockFruit.id;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        this.func_149719_a((IBlockAccess)world, x, y, z);
        return super.func_149668_a(world, x, y, z);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_149633_g(World world, int x, int y, int z) {
        this.func_149719_a((IBlockAccess)world, x, y, z);
        return super.func_149633_g(world, x, y, z);
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        float f = 0.0625f;
        if (meta == 0) {
            this.func_149676_a(0.375f, 0.6875f, 0.375f, 0.625f, 0.9375f, 0.625f);
        } else if (meta == 1) {
            this.func_149676_a(0.34375f, 0.625f, 0.34375f, 0.65625f, 0.9375f, 0.65625f);
        } else {
            this.func_149676_a(0.3125f, 0.5625f, 0.3125f, 0.6875f, 0.9375f, 0.6875f);
        }
    }

    public static class AppleStage {
        public static final int YOUNG = 0;
        public static final int MID = 1;
        public static final int MATURE = 2;
        public static final int COUNT = 3;

        private AppleStage() {
        }
    }
}

