/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.api.milk.churn;

import growthcraft.api.core.fluids.FluidKey;
import growthcraft.api.core.fluids.FluidTest;
import growthcraft.api.core.log.ILogger;
import growthcraft.api.core.log.NullLogger;
import growthcraft.api.milk.churn.ChurnRecipe;
import growthcraft.api.milk.churn.IChurnRecipe;
import growthcraft.api.milk.churn.IChurnRegistry;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class ChurnRegistry
implements IChurnRegistry {
    protected ILogger logger = NullLogger.INSTANCE;
    private Map<Fluid, IChurnRecipe> recipes = new HashMap<Fluid, IChurnRecipe>();
    private Set<FluidKey> fluidIngredients = new HashSet<FluidKey>();

    @Override
    public void setLogger(@Nonnull ILogger l) {
        this.logger = l;
    }

    @Override
    public void addRecipe(@Nonnull IChurnRecipe recipe) {
        FluidStack fluidStack = recipe.getInputFluidStack();
        Fluid fluid = fluidStack.getFluid();
        if (this.recipes.containsKey(fluid)) {
            this.logger.warn("Overwriting existing churn recipe for {%s} with {%s}", fluidStack, recipe);
        } else {
            this.logger.debug("Adding new churn recipe {%s}", recipe);
        }
        this.fluidIngredients.add(new FluidKey(fluidStack));
        this.recipes.put(fluid, recipe);
    }

    @Override
    public void addRecipe(@Nonnull FluidStack inputFluid, @Nonnull FluidStack outputFluid, @Nullable ItemStack outputItem, int churns) {
        Fluid fluid = inputFluid.getFluid();
        if (fluid == null) {
            throw new IllegalArgumentException("The provided input fluid is invalid.");
        }
        ChurnRecipe recipe = new ChurnRecipe(inputFluid, outputFluid, outputItem, churns);
        this.addRecipe(recipe);
    }

    @Override
    public boolean isFluidIngredient(@Nullable Fluid fluid) {
        if (fluid != null) {
            return this.fluidIngredients.contains(new FluidKey(fluid));
        }
        return false;
    }

    @Override
    public boolean isFluidIngredient(@Nullable FluidStack stack) {
        if (FluidTest.isValid(stack)) {
            return this.fluidIngredients.contains(new FluidKey(stack));
        }
        return false;
    }

    @Override
    @Nullable
    public IChurnRecipe getRecipe(FluidStack stack) {
        if (stack == null) {
            return null;
        }
        Fluid fluid = stack.getFluid();
        if (fluid == null) {
            return null;
        }
        IChurnRecipe recipe = this.recipes.get(fluid);
        if (recipe != null && recipe.isValidForRecipe(stack)) {
            return recipe;
        }
        return null;
    }
}

