/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.api.fishtrap;

import growthcraft.api.core.log.ILoggable;
import growthcraft.api.core.log.ILogger;
import growthcraft.api.core.log.NullLogger;
import growthcraft.api.fishtrap.BaitRegistry;
import growthcraft.api.fishtrap.CatchGroupEntry;
import growthcraft.api.fishtrap.FishTrapEntry;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.WeightedRandom;
import net.minecraft.world.World;

public class FishTrapRegistry
implements ILoggable {
    private static final FishTrapRegistry instance = new FishTrapRegistry();
    private final BaitRegistry baits = new BaitRegistry();
    private final Set<CatchGroupEntry> catchGroups = new HashSet<CatchGroupEntry>();
    private final Map<String, List<FishTrapEntry>> entriesByGroup = new HashMap<String, List<FishTrapEntry>>();
    private ILogger logger = NullLogger.INSTANCE;

    public static final FishTrapRegistry instance() {
        return instance;
    }

    @Override
    public void setLogger(@Nonnull ILogger l) {
        this.logger = l;
    }

    public void addBait(Object stack, BaitRegistry.BaitHandle handle) {
        this.logger.debug("Adding FishTrap Bait `%s`", stack);
        this.baits.add(stack, handle);
    }

    public void addBait(Object stack, float base, float mul) {
        this.addBait(stack, new BaitRegistry.BaitHandle(base, mul));
    }

    public BaitRegistry.BaitHandle findBait(ItemStack stack) {
        return this.baits.findHandle(stack);
    }

    public void addCatchGroup(String name, int weight) {
        this.logger.debug("Adding Catch Group group=`%s` weight=%d", name, weight);
        this.catchGroups.add(new CatchGroupEntry(name, weight));
    }

    public Collection<CatchGroupEntry> getCatchGroups() {
        return this.catchGroups;
    }

    public String getRandomCatchGroup(Random random) {
        CatchGroupEntry entry = (CatchGroupEntry)WeightedRandom.func_76271_a((Random)random, this.getCatchGroups());
        if (entry != null) {
            return entry.getName();
        }
        return null;
    }

    public void addCatchToGroup(FishTrapEntry entry, String group) {
        if (!this.entriesByGroup.containsKey(group)) {
            this.entriesByGroup.put(group, new LinkedList());
        }
        this.entriesByGroup.get(group).add(entry);
    }

    private ItemStack getRandomCatchFromList(Random random, List<FishTrapEntry> list) {
        if (list.isEmpty()) {
            return null;
        }
        return ((FishTrapEntry)WeightedRandom.func_76271_a((Random)random, list)).getFishable(random);
    }

    public ItemStack getRandomCatchFromGroup(Random random, String group) {
        List<FishTrapEntry> list = this.entriesByGroup.get(group);
        if (list != null) {
            return this.getRandomCatchFromList(random, list);
        }
        return null;
    }

    @Deprecated
    public void addTrapFish(FishTrapEntry entry) {
        this.addCatchToGroup(entry, "fish");
    }

    @Deprecated
    public void addTrapTreasure(FishTrapEntry entry) {
        this.addCatchToGroup(entry, "treasure");
    }

    @Deprecated
    public void addTrapJunk(FishTrapEntry entry) {
        this.addCatchToGroup(entry, "junk");
    }

    @Deprecated
    public ItemStack getFishList(World world) {
        return this.getRandomCatchFromGroup(world.field_73012_v, "fish");
    }

    @Deprecated
    public ItemStack getTreasureList(World world) {
        return this.getRandomCatchFromGroup(world.field_73012_v, "treasure");
    }

    @Deprecated
    public ItemStack getJunkList(World world) {
        return this.getRandomCatchFromGroup(world.field_73012_v, "junk");
    }
}

