/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.api.core.util;

import growthcraft.api.core.definition.IMultiFluidStacks;
import growthcraft.api.core.definition.IMultiItemStacks;
import growthcraft.api.core.fluids.MultiFluidStacks;
import growthcraft.api.core.fluids.TaggedFluidStacks;
import growthcraft.api.core.item.MultiItemStacks;
import growthcraft.api.core.item.OreItemStacks;
import growthcraft.api.core.log.ILogger;
import growthcraft.api.core.log.NullLogger;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class MultiStacksUtil {
    private static ILogger logger = NullLogger.INSTANCE;

    private MultiStacksUtil() {
    }

    public static void setLogger(@Nonnull ILogger l) {
        logger = l;
    }

    private static <T> List<List<T>> expandedCombinations(@Nonnull List<List<T>> expandedStacks) {
        int columnCount = expandedStacks.size();
        int[] colIndices = new int[columnCount];
        int[] colMax = new int[columnCount];
        ArrayList<List<T>> result = new ArrayList<List<T>>();
        for (int i = 0; i < colIndices.length; ++i) {
            colIndices[i] = 0;
            colMax[i] = expandedStacks.get(i).size();
        }
        int lastCol = colIndices.length - 1;
        boolean abortOuter = false;
        while (colIndices[lastCol] < colMax[lastCol]) {
            ArrayList<T> row = new ArrayList<T>();
            for (int col = 0; col < colIndices.length; ++col) {
                if (colIndices[col] >= colMax[col]) {
                    if (col < columnCount - 1) {
                        colIndices[col] = 0;
                        int n = col + 1;
                        colIndices[n] = colIndices[n] + 1;
                    } else {
                        abortOuter = true;
                        break;
                    }
                }
                List<T> colStacks = expandedStacks.get(col);
                int colIndex = colIndices[col];
                row.add(colStacks.get(colIndex));
            }
            if (abortOuter) break;
            if (row.size() == columnCount) {
                result.add(row);
            }
            colIndices[0] = colIndices[0] + 1;
        }
        return result;
    }

    public static List<List<ItemStack>> expandedItemStackCombinations(@Nonnull List<IMultiItemStacks> srcList) {
        ArrayList expandedStacks = new ArrayList();
        for (IMultiItemStacks stacks : srcList) {
            expandedStacks.add(stacks.getItemStacks());
        }
        return MultiStacksUtil.expandedCombinations(expandedStacks);
    }

    public static List<List<FluidStack>> expandedFluidStackCombinations(@Nonnull List<IMultiFluidStacks> srcList) {
        ArrayList expandedStacks = new ArrayList();
        for (IMultiFluidStacks stacks : srcList) {
            expandedStacks.add(stacks.getFluidStacks());
        }
        return MultiStacksUtil.expandedCombinations(expandedStacks);
    }

    public static IMultiItemStacks toMultiItemStacks(@Nonnull Object obj) {
        if (obj instanceof IMultiItemStacks) {
            return (IMultiItemStacks)obj;
        }
        if (obj instanceof ItemStack) {
            return new MultiItemStacks((ItemStack)obj);
        }
        throw new IllegalArgumentException("Wrong type, expected a ItemStack or IMultiItemStacks");
    }

    public static IMultiFluidStacks toMultiFluidStacks(@Nonnull Object obj) {
        if (obj instanceof IMultiFluidStacks) {
            return (IMultiFluidStacks)obj;
        }
        if (obj instanceof FluidStack) {
            return new MultiFluidStacks((FluidStack)obj);
        }
        throw new IllegalArgumentException("Wrong type, expected a FluidStack or IMultiFluidStacks");
    }

    public static List<ItemStack> expandItemStacks(@Nonnull List<ItemStack> list, @Nonnull Object obj) {
        if (obj instanceof ItemStack) {
            list.add((ItemStack)obj);
        } else if (obj instanceof OreItemStacks) {
            OreItemStacks oreItemStack = (OreItemStacks)obj;
            List<ItemStack> stacks = oreItemStack.getItemStacks();
            if (stacks.isEmpty()) {
                logger.error("Ore stack '%s' was empty!", oreItemStack.getName());
            } else {
                logger.debug("Expanded OreItemStack '%s' to %s", oreItemStack.getName(), stacks);
                list.addAll(stacks);
            }
        } else if (obj instanceof IMultiItemStacks) {
            list.addAll(((IMultiItemStacks)obj).getItemStacks());
        } else {
            throw new IllegalArgumentException("Wrong type, expected a ItemStack or IMultiItemStacks");
        }
        return list;
    }

    public static List<FluidStack> expandFluidStacks(@Nonnull List<FluidStack> list, @Nonnull Object obj) {
        if (obj instanceof FluidStack) {
            list.add((FluidStack)obj);
        } else if (obj instanceof TaggedFluidStacks) {
            TaggedFluidStacks taggedFluidStack = (TaggedFluidStacks)obj;
            List<FluidStack> stacks = taggedFluidStack.getFluidStacks();
            if (stacks.isEmpty()) {
                logger.error("Tagged Fluid stack (tags: %s) was empty!", taggedFluidStack.getTags());
            } else {
                logger.debug("Expanded TaggedFluidStacks(tags: %s) to [%s]", taggedFluidStack.getTags(), stacks);
                list.addAll(stacks);
            }
        } else if (obj instanceof IMultiFluidStacks) {
            list.addAll(((IMultiFluidStacks)obj).getFluidStacks());
        } else {
            throw new IllegalArgumentException("Wrong type, expected a FluidStack or TaggedFluidStacks");
        }
        return list;
    }
}

