/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.api.core.util;

import growthcraft.api.core.util.BoundUtils;

public class BBox {
    public float[] boundsData = new float[6];

    public BBox() {
    }

    public BBox(float[] bounds) {
        this();
        assert (bounds.length == 6);
        this.boundsData[0] = bounds[0];
        this.boundsData[1] = bounds[1];
        this.boundsData[2] = bounds[2];
        this.boundsData[3] = bounds[3];
        this.boundsData[4] = bounds[4];
        this.boundsData[5] = bounds[5];
    }

    public BBox(float px0, float py0, float pz0, float px1, float py1, float pz1) {
        this();
        this.boundsData[0] = px0;
        this.boundsData[1] = py0;
        this.boundsData[2] = pz0;
        this.boundsData[3] = px1;
        this.boundsData[4] = py1;
        this.boundsData[5] = pz1;
    }

    public BBox translate(float x, float y, float z) {
        BoundUtils.translateBounds(this.boundsData, x, y, z, this.boundsData);
        return this;
    }

    public BBox scale(float px0, float py0, float pz0, float px1, float py1, float pz1) {
        this.boundsData[0] = this.boundsData[0] * px0;
        this.boundsData[1] = this.boundsData[1] * py0;
        this.boundsData[2] = this.boundsData[2] * pz0;
        this.boundsData[3] = this.boundsData[3] * px1;
        this.boundsData[4] = this.boundsData[4] * py1;
        this.boundsData[5] = this.boundsData[5] * pz1;
        return this;
    }

    public BBox scale(float x, float y, float z) {
        return this.scale(x, y, z, x, y, z);
    }

    public BBox scale(float ps) {
        return this.scale(ps, ps, ps);
    }

    public float x0() {
        return this.boundsData[0];
    }

    public float y0() {
        return this.boundsData[1];
    }

    public float z0() {
        return this.boundsData[2];
    }

    public float x1() {
        return this.boundsData[3];
    }

    public float y1() {
        return this.boundsData[4];
    }

    public float z1() {
        return this.boundsData[5];
    }

    public float w() {
        return this.x1() - this.x0();
    }

    public float h() {
        return this.y1() - this.y0();
    }

    public float l() {
        return this.z1() - this.z0();
    }

    public boolean contains(float px, float py, float pz) {
        return this.x0() >= px && this.x1() <= px && this.y0() >= py && this.y1() <= py && this.z0() >= pz && this.z1() <= pz;
    }

    public static BBox newCube(float x, float y, float z, float w, float h, float l) {
        return new BBox(x, y, z, x + w, y + h, z + l);
    }

    public static BBox newCentered(float pw, float ph, float pl) {
        BBox result = new BBox();
        BoundUtils.centeredCubeBounds(result.boundsData, pw, ph, pl);
        return result;
    }
}

