/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.api.core.item.recipes;

import growthcraft.api.core.definition.IItemStackListProvider;
import growthcraft.api.core.definition.IMultiItemStacks;
import growthcraft.api.core.fluids.FluidUtils;
import growthcraft.api.core.item.MultiItemStacks;
import growthcraft.api.core.item.OreItemStacks;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import net.minecraft.block.Block;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class ShapedMultiRecipe
implements IRecipe {
    private static final int MAX_CRAFT_GRID_WIDTH = 3;
    private static final int MAX_CRAFT_GRID_HEIGHT = 3;
    private ItemStack output;
    private ArrayList<IItemStackListProvider> input;
    private int width;
    private int height;
    private boolean mirrored = true;

    public ShapedMultiRecipe(Block result, Object ... recipe) {
        this(new ItemStack(result), recipe);
    }

    public ShapedMultiRecipe(Item result, Object ... recipe) {
        this(new ItemStack(result), recipe);
    }

    public ShapedMultiRecipe(ItemStack result, Object ... recipe) {
        this.output = result.func_77946_l();
        String shape = "";
        int idx = 0;
        if (recipe[idx] instanceof Boolean) {
            this.mirrored = (Boolean)recipe[idx];
            if (recipe[idx + 1] instanceof Object[]) {
                recipe = (Object[])recipe[idx + 1];
            } else {
                idx = 1;
            }
        }
        if (recipe[idx] instanceof String[]) {
            String[] parts;
            for (String s : parts = (String[])recipe[idx++]) {
                this.width = s.length();
                shape = shape + s;
            }
            this.height = parts.length;
        } else {
            while (recipe[idx] instanceof String) {
                String s = (String)recipe[idx++];
                shape = shape + s;
                this.width = s.length();
                ++this.height;
            }
        }
        if (this.width * this.height != shape.length()) {
            String ret = "Invalid shaped ore recipe: ";
            for (Object tmp : recipe) {
                ret = ret + tmp + ", ";
            }
            ret = ret + this.output;
            throw new RuntimeException(ret);
        }
        HashMap<Character, IItemStackListProvider> itemMap = new HashMap<Character, IItemStackListProvider>();
        while (idx < recipe.length) {
            Character c = (Character)recipe[idx];
            Object in = recipe[idx + 1];
            if (in instanceof ItemStack) {
                itemMap.put(c, new MultiItemStacks((ItemStack)in).copy());
            } else if (in instanceof Item) {
                itemMap.put(c, new MultiItemStacks(new ItemStack((Item)in)));
            } else if (in instanceof Block) {
                itemMap.put(c, new MultiItemStacks(new ItemStack((Block)in, 1, Short.MAX_VALUE)));
            } else if (in instanceof String) {
                itemMap.put(c, new OreItemStacks((String)in));
            } else if (in instanceof IItemStackListProvider) {
                itemMap.put(c, (IItemStackListProvider)in);
            } else if (in instanceof FluidStack) {
                itemMap.put(c, new MultiItemStacks(FluidUtils.getFluidContainers((FluidStack)in)));
            } else {
                String ret = "Invalid shaped multi recipe: ";
                for (Object tmp : recipe) {
                    ret = ret + tmp + ", ";
                }
                ret = ret + this.output;
                throw new RuntimeException(ret);
            }
            idx += 2;
        }
        this.input = new ArrayList(this.width * this.height);
        for (char chr : shape.toCharArray()) {
            this.input.add((IItemStackListProvider)itemMap.get(Character.valueOf(chr)));
        }
    }

    public ItemStack func_77572_b(InventoryCrafting var1) {
        return this.output.func_77946_l();
    }

    public int func_77570_a() {
        return this.input.size();
    }

    public ItemStack func_77571_b() {
        return this.output;
    }

    public boolean func_77569_a(InventoryCrafting inv, World world) {
        for (int x = 0; x <= 3 - this.width; ++x) {
            for (int y = 0; y <= 3 - this.height; ++y) {
                if (this.checkMatch(inv, x, y, false)) {
                    return true;
                }
                if (!this.mirrored || !this.checkMatch(inv, x, y, true)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkMatch(InventoryCrafting inv, int startX, int startY, boolean mirror) {
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                int subX = x - startX;
                int subY = y - startY;
                IItemStackListProvider target = null;
                if (subX >= 0 && subY >= 0 && subX < this.width && subY < this.height) {
                    target = mirror ? this.input.get(this.width - subX - 1 + subY * this.width) : this.input.get(subX + subY * this.width);
                }
                ItemStack slot = inv.func_70463_b(x, y);
                if (target instanceof IMultiItemStacks) {
                    boolean matched = false;
                    Iterator<ItemStack> itr = target.getItemStacks().iterator();
                    while (itr.hasNext() && !matched) {
                        matched = OreDictionary.itemMatches((ItemStack)itr.next(), (ItemStack)slot, (boolean)false);
                    }
                    if (matched) continue;
                    return false;
                }
                if (target != null || slot == null) continue;
                return false;
            }
        }
        return true;
    }

    public ShapedMultiRecipe setMirrored(boolean mirror) {
        this.mirrored = mirror;
        return this;
    }

    public ArrayList<IItemStackListProvider> getInput() {
        return this.input;
    }
}

