/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.api.core.item;

import growthcraft.api.core.definition.IItemStackFactory;
import growthcraft.api.core.nbt.NBTHelper;
import growthcraft.api.core.util.HashKey;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ItemKey
extends HashKey
implements IItemStackFactory {
    public static final int WILDCARD_VALUE = Short.MAX_VALUE;
    public final Item item;
    public final int meta;
    public final NBTTagCompound compoundTag;

    public ItemKey(@Nonnull Item pitem, int pmeta, @Nullable NBTTagCompound tag) {
        this.item = pitem;
        this.meta = pmeta;
        this.compoundTag = NBTHelper.compoundTagPresence(tag);
        this.generateHashCode();
    }

    public ItemKey(@Nonnull Item pitem, int pmeta) {
        this(pitem, pmeta, null);
    }

    public ItemKey(@Nonnull Block block, int pmeta, @Nullable NBTTagCompound tag) {
        Item pitem = Item.func_150898_a((Block)block);
        if (pitem == null) {
            throw new IllegalArgumentException("Invalid Block given for ItemKey (block=" + block + " meta=" + pmeta + ")");
        }
        this.item = pitem;
        this.meta = pmeta;
        this.compoundTag = NBTHelper.compoundTagPresence(tag);
        this.generateHashCode();
    }

    public ItemKey(@Nonnull Block block, int pmeta) {
        this(block, pmeta, null);
    }

    public ItemKey(@Nonnull ItemStack stack) {
        this(stack.func_77973_b(), stack.func_77960_j(), stack.func_77978_p());
    }

    private void generateHashCode() {
        this.hash = this.item.hashCode();
        this.hash = 31 * this.hash + this.meta;
        this.hash = 31 * this.hash + (this.compoundTag != null ? this.compoundTag.hashCode() : 0);
    }

    @Override
    public ItemStack asStack(int size) {
        ItemStack result = new ItemStack(this.item, size, this.meta);
        result.func_77982_d(NBTHelper.copyCompoundTag(this.compoundTag));
        return result;
    }

    @Override
    public ItemStack asStack() {
        return this.asStack(1);
    }

    public static ItemKey newWoNBT(@Nonnull ItemStack stack) {
        return new ItemKey(stack.func_77973_b(), stack.func_77960_j());
    }
}

