/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.api.core.fluids;

import growthcraft.api.core.fluids.FluidTag;
import growthcraft.api.core.fluids.IFluidDictionary;
import growthcraft.api.core.log.ILogger;
import growthcraft.api.core.log.NullLogger;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class FluidDictionary
implements IFluidDictionary {
    private Map<Fluid, Set<FluidTag>> fluidToTagsMap = new HashMap<Fluid, Set<FluidTag>>();
    private Map<FluidTag, Set<Fluid>> tagToFluidsMap = new HashMap<FluidTag, Set<Fluid>>();
    private ILogger logger = NullLogger.INSTANCE;

    @Override
    public void setLogger(@Nonnull ILogger l) {
        this.logger = l;
    }

    @Override
    public void addFluidTags(@Nonnull Fluid fluid, FluidTag ... tags) {
        if (!this.fluidToTagsMap.containsKey(fluid)) {
            this.logger.debug("Initializing new HashSet for fluid {%s}", fluid);
            this.fluidToTagsMap.put(fluid, new HashSet());
        }
        Set<FluidTag> tagSet = this.fluidToTagsMap.get(fluid);
        for (FluidTag tag : tags) {
            this.logger.debug("Adding tag '%s' to fluid {%s}", tag, fluid);
            tagSet.add(tag);
            if (!this.tagToFluidsMap.containsKey(tag)) {
                this.tagToFluidsMap.put(tag, new HashSet());
            }
            this.tagToFluidsMap.get(tag).add(fluid);
        }
    }

    @Override
    public Collection<FluidTag> getFluidTags(@Nullable Fluid fluid) {
        if (fluid == null) {
            return null;
        }
        return this.fluidToTagsMap.get(fluid);
    }

    @Override
    public Collection<FluidTag> getFluidTags(@Nullable FluidStack stack) {
        if (stack == null) {
            return null;
        }
        return this.getFluidTags(stack.getFluid());
    }

    @Override
    public boolean hasFluidTags(@Nonnull Fluid fluid, FluidTag ... tags) {
        Set<FluidTag> fluidTags = this.fluidToTagsMap.get(fluid);
        if (fluidTags == null) {
            return false;
        }
        for (FluidTag tag : tags) {
            if (fluidTags.contains(tag)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Collection<Fluid> getFluidsByTags(@Nonnull List<FluidTag> tags) {
        Set<Fluid> prim;
        HashSet<Fluid> fluids = new HashSet<Fluid>();
        if (tags.size() > 0 && (prim = this.tagToFluidsMap.get(tags.get(0))) != null) {
            fluids.addAll(prim);
            for (int i = 1; i < tags.size() && !fluids.isEmpty(); ++i) {
                Set<Fluid> exc = this.tagToFluidsMap.get(tags.get(i));
                fluids.retainAll(exc);
            }
        }
        return fluids;
    }

    @Override
    public Collection<Fluid> getFluidsByTags(FluidTag ... tags) {
        return this.getFluidsByTags(Arrays.asList(tags));
    }
}

