/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.api.cellar.booze.effect;

import growthcraft.api.core.effect.AbstractEffect;
import growthcraft.api.core.i18n.GrcI18n;
import growthcraft.api.core.stats.IAchievement;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class EffectTipsy
extends AbstractEffect {
    public static Potion potionTipsy;
    public static IAchievement achievement;
    private boolean hasTipsyEffect;
    private float tipsyChance;
    private int tipsyTime;

    public EffectTipsy clear() {
        this.hasTipsyEffect = false;
        this.tipsyChance = 0.0f;
        this.tipsyTime = 0;
        return this;
    }

    public EffectTipsy setTipsy(float chance, int time) {
        this.hasTipsyEffect = true;
        this.tipsyChance = MathHelper.func_76131_a((float)chance, (float)0.1f, (float)1.0f);
        this.tipsyTime = time;
        return this;
    }

    public boolean canCauseTipsy() {
        return this.hasTipsyEffect;
    }

    public float getTipsyChance() {
        return this.tipsyChance;
    }

    public int getTipsyTime() {
        return this.tipsyTime;
    }

    @Override
    public void apply(World world, Entity entity, Random random, Object data) {
        if (entity instanceof EntityLivingBase) {
            EntityLivingBase entitylb = (EntityLivingBase)entity;
            if (!this.canCauseTipsy()) {
                return;
            }
            if (world.field_73012_v.nextFloat() > this.getTipsyChance()) {
                return;
            }
            int amplifier = 0;
            int time = 1200;
            if (entitylb.func_70644_a(potionTipsy) && (amplifier = entitylb.func_70660_b(potionTipsy).func_76458_c() + 1) > 4) {
                amplifier = 4;
            }
            switch (amplifier) {
                case 1: {
                    time = 3000;
                    break;
                }
                case 2: {
                    time = 6750;
                    break;
                }
                case 3: {
                    time = 12000;
                    break;
                }
                case 4: {
                    time = 24000;
                    break;
                }
            }
            entitylb.func_70690_d(new PotionEffect(EffectTipsy.potionTipsy.field_76415_H, time, amplifier));
            if (entitylb instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)entitylb;
                if (amplifier >= 4) {
                    achievement.addStat(player, 1);
                }
            }
        }
    }

    @Override
    protected void getActualDescription(List<String> list) {
        PotionEffect nausea = new PotionEffect(Potion.field_76431_k.field_76415_H, this.getTipsyTime(), 0);
        String p = GrcI18n.translate("grc.cellar.format.tipsy_chance", Math.round(this.getTipsyChance() * 100.0f));
        String n = "";
        if (nausea.func_76459_b() > 20) {
            n = "(" + Potion.func_76389_a((PotionEffect)nausea) + ")";
        }
        list.add(EnumChatFormatting.GRAY + p + EnumChatFormatting.GRAY + " " + n);
    }

    @Override
    protected void readFromNBT(NBTTagCompound data) {
        this.hasTipsyEffect = data.func_74767_n("has_tipsy_effect");
        this.tipsyChance = data.func_74760_g("tipsy_chance");
        this.tipsyTime = data.func_74762_e("tipsy_time");
    }

    @Override
    protected void writeToNBT(NBTTagCompound data) {
        data.func_74757_a("has_tipsy_effect", this.hasTipsyEffect);
        data.func_74776_a("tipsy_chance", this.tipsyChance);
        data.func_74768_a("tipsy_time", this.tipsyTime);
    }
}

