/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.milk.shared.processing.churn.user;

import growthcraft.core.shared.config.schema.FluidStackSchema;
import growthcraft.core.shared.config.schema.ICommentable;
import growthcraft.core.shared.config.schema.ItemKeySchema;
import growthcraft.milk.shared.processing.churn.ChurnRecipe;
import growthcraft.milk.shared.processing.churn.IChurnRecipe;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class UserChurnRecipe
implements ICommentable {
    public String comment = "";
    public FluidStackSchema input_fluid;
    public FluidStackSchema output_fluid;
    public ItemKeySchema output_item;
    public int churns;

    public UserChurnRecipe(FluidStackSchema pInputFluid, FluidStackSchema pOutputFluid, ItemKeySchema pOutputItem, int pChurns) {
        this.output_item = pOutputItem;
        this.input_fluid = pInputFluid;
        this.output_fluid = pOutputFluid;
        this.churns = pChurns;
    }

    public UserChurnRecipe() {
    }

    public String toString() {
        return String.format("UserChurnRecipe(`%s` / %d = `%s` & `%s`)", this.input_fluid, this.churns, this.output_fluid, this.output_item);
    }

    @Override
    public void setComment(String comm) {
        this.comment = comm;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    public List<IChurnRecipe> toChurnRecipes() {
        FluidStack outputFluidStack;
        ArrayList<IChurnRecipe> recipes = new ArrayList<IChurnRecipe>();
        FluidStack inputFluidStack = this.input_fluid.asFluidStack();
        FluidStack fluidStack = outputFluidStack = this.output_fluid != null ? this.output_fluid.asFluidStack() : null;
        if (this.output_item != null && this.output_item.isValid()) {
            Iterator<ItemStack> iterator = this.output_item.getItemStacks().iterator();
            if (iterator.hasNext()) {
                ItemStack stack = iterator.next();
                recipes.add(new ChurnRecipe(inputFluidStack, outputFluidStack, stack, this.churns));
            }
        } else {
            recipes.add(new ChurnRecipe(inputFluidStack, outputFluidStack, null, this.churns));
        }
        return recipes;
    }
}

