/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.milk.common.tileentity.device;

import growthcraft.core.shared.tileentity.GrowthcraftTileDeviceBase;
import growthcraft.core.shared.tileentity.device.DeviceInventorySlot;
import growthcraft.core.shared.tileentity.device.DeviceProgressive;
import growthcraft.milk.common.tileentity.TileEntityCheesePress;
import growthcraft.milk.shared.MilkRegistry;
import growthcraft.milk.shared.processing.cheesepress.ICheesePressRecipe;
import net.minecraft.inventory.IInventory;

public class CheesePress
extends DeviceProgressive<ICheesePressRecipe> {
    private DeviceInventorySlot invSlot;

    public CheesePress(GrowthcraftTileDeviceBase te) {
        super(te);
        this.invSlot = new DeviceInventorySlot((IInventory)te, 0);
    }

    @Override
    protected ICheesePressRecipe loadRecipe() {
        return MilkRegistry.instance().cheesePress().findRecipe(this.invSlot.get());
    }

    @Override
    protected boolean canProcess() {
        ICheesePressRecipe recipe = (ICheesePressRecipe)this.getWorkingRecipe();
        if (this.invSlot.get() == null) {
            return false;
        }
        if (recipe == null) {
            return false;
        }
        return this.invSlot.hasEnough(recipe.getInputItemStack());
    }

    @Override
    protected float getSpeedMultiplier() {
        if (this.parent instanceof TileEntityCheesePress) {
            return super.getSpeedMultiplier() * (float)(((TileEntityCheesePress)this.parent).isPressed() ? 1 : 0);
        }
        return super.getSpeedMultiplier();
    }

    @Override
    public void process(ICheesePressRecipe recipe) {
        if (recipe != null) {
            this.invSlot.set(recipe.getOutputItemStack().func_77946_l());
        }
    }
}

