/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.milk.common.block;

import growthcraft.core.shared.block.BlockCheck;
import growthcraft.core.shared.block.GrowthcraftBlockContainer;
import growthcraft.milk.common.tileentity.TileEntityHangingCurds;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockHangingCurds
extends GrowthcraftBlockContainer {
    private static final AxisAlignedBB BOUNDING_BOX = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 1.0, 0.75);
    public static final PropertyInteger TYPE_CHEESE_VARIANT = PropertyInteger.func_177719_a((String)"type", (int)0, (int)9);

    public BlockHangingCurds() {
        super(Material.field_151568_F);
        this.func_149711_c(6.0f);
        this.func_149675_a(true);
        this.func_149672_a(SoundType.field_185854_g);
        this.setTileEntityType(TileEntityHangingCurds.class);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a((IProperty)TYPE_CHEESE_VARIANT, (Comparable)Integer.valueOf(0)));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOUNDING_BOX;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean p_185477_7_) {
        BlockHangingCurds.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)BOUNDING_BOX);
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    @Override
    protected boolean shouldRestoreBlockState(World world, BlockPos pos, ItemStack stack) {
        return true;
    }

    @Override
    protected boolean shouldDropTileStack(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        return true;
    }

    @Override
    protected ItemStack createHarvestedBlockItemStack(World world, EntityPlayer player, BlockPos pos, IBlockState state) {
        TileEntityHangingCurds te = (TileEntityHangingCurds)this.getTileEntity((IBlockAccess)world, pos);
        if (te != null) {
            return te.asItemStack();
        }
        return new ItemStack((Block)this, 1, this.func_180651_a(state));
    }

    @Override
    protected void getTileItemStackDrops(List<ItemStack> ret, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        TileEntityHangingCurds te = (TileEntityHangingCurds)this.getTileEntity(world, pos);
        if (te != null) {
            ret.add(te.asItemStack());
        } else {
            super.getTileItemStackDrops(ret, world, pos, state, fortune);
        }
    }

    @Override
    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntityHangingCurds hangingCurd;
        if (super.func_180639_a(worldIn, pos, state, playerIn, hand, facing, hitX, hitY, hitZ)) {
            return true;
        }
        if (!playerIn.func_70093_af() && (hangingCurd = (TileEntityHangingCurds)this.getTileEntity((IBlockAccess)worldIn, pos)) != null && hangingCurd.isDried()) {
            this.fellBlockAsItem(worldIn, pos);
            return true;
        }
        return false;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        TileEntityHangingCurds teHangingCurds = (TileEntityHangingCurds)this.getTileEntity((IBlockAccess)world, pos);
        if (teHangingCurds != null) {
            return teHangingCurds.asItemStack();
        }
        return super.getPickBlock(state, target, world, pos, player);
    }

    public boolean canBlockStay(World world, BlockPos pos) {
        return !world.func_175623_d(pos.func_177984_a()) && BlockCheck.isBlockPlacableOnSide(world, pos.func_177984_a(), EnumFacing.DOWN);
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        return super.func_176196_c(world, pos) && this.canBlockStay(world, pos);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!this.canBlockStay(worldIn, pos)) {
            this.fellBlockAsItem(worldIn, pos);
        }
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random random) {
        super.func_180650_b(world, pos, state, random);
        if (!world.field_72995_K && !this.canBlockStay(world, pos)) {
            this.func_176226_b(world, pos, state, 0);
            world.func_175698_g(pos);
        }
    }

    @Override
    public int func_180651_a(IBlockState state) {
        return state.func_177230_c().func_176201_c(state);
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE_CHEESE_VARIANT});
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileEntityHangingCurds teHangingCurds = (TileEntityHangingCurds)this.getTileEntity(worldIn, pos);
        if (teHangingCurds != null) {
            return state.func_177226_a((IProperty)TYPE_CHEESE_VARIANT, (Comparable)Integer.valueOf(teHangingCurds.getCheeseType().getVariantID()));
        }
        return state.func_177226_a((IProperty)TYPE_CHEESE_VARIANT, (Comparable)Integer.valueOf(0));
    }
}

