/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.milk.common.block;

import growthcraft.core.shared.block.GrowthcraftBlockContainer;
import growthcraft.core.shared.compat.theoneprobe.ITheOneProbeInfoProvider;
import growthcraft.milk.common.tileentity.TileEntityCheeseVat;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockCheeseVat
extends GrowthcraftBlockContainer
implements ITheOneProbeInfoProvider {
    public static final PropertyBool ATTACH_NORTH = PropertyBool.func_177716_a((String)"attachnorth");
    public static final PropertyBool ATTACH_SOUTH = PropertyBool.func_177716_a((String)"attachsouth");
    public static final PropertyBool ATTACH_EAST = PropertyBool.func_177716_a((String)"attacheast");
    public static final PropertyBool ATTACH_WEST = PropertyBool.func_177716_a((String)"attachwest");
    private static final AxisAlignedBB BOUNDING_BOX = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.875, 0.9375);

    public BlockCheeseVat(String unlocalizedName) {
        super(Material.field_151573_f, MapColor.field_151665_m);
        this.func_149663_c(unlocalizedName);
        this.setRegistryName(new ResourceLocation("growthcraft_milk", unlocalizedName));
        this.func_149752_b(5.0f);
        this.func_149711_c(2.0f);
        this.setHarvestLevel("pickaxe", 1);
        this.func_149672_a(SoundType.field_185852_e);
        this.field_149783_u = true;
        this.func_180632_j(this.field_176227_L.func_177621_b());
        this.setTileEntityType(TileEntityCheeseVat.class);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random random) {
        TileEntityCheeseVat te;
        if (random.nextInt(12) == 0 && (te = (TileEntityCheeseVat)this.getTileEntity((IBlockAccess)world, pos)) != null && te.isWorking()) {
            for (int i = 0; i < 3; ++i) {
                double px = (double)pos.func_177958_n() + 0.5 + ((double)random.nextFloat() - 0.5);
                double py = (double)pos.func_177956_o() + 0.0625;
                double pz = (double)pos.func_177952_p() + 0.5 + ((double)random.nextFloat() - 0.5);
                world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, px, py, pz, 0.0, 0.03125, 0.0, new int[0]);
                world.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187662_cZ, SoundCategory.BLOCKS, 0.3f, 0.5f, false);
            }
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOUNDING_BOX;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean p_185477_7_) {
        BlockCheeseVat.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)BOUNDING_BOX);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return face == EnumFacing.UP ? BlockFaceShape.BOWL : BlockFaceShape.UNDEFINED;
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{ATTACH_NORTH, ATTACH_SOUTH, ATTACH_EAST, ATTACH_WEST});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        BlockPos down = pos.func_177977_b();
        IBlockState stateDown = worldIn.func_180495_p(down);
        boolean isOpaqueDown = stateDown.func_185914_p();
        return state.func_177226_a((IProperty)ATTACH_NORTH, (Comparable)Boolean.valueOf(!isOpaqueDown && worldIn.func_180495_p(down.func_177978_c()).func_185914_p())).func_177226_a((IProperty)ATTACH_SOUTH, (Comparable)Boolean.valueOf(!isOpaqueDown && worldIn.func_180495_p(down.func_177968_d()).func_185914_p())).func_177226_a((IProperty)ATTACH_EAST, (Comparable)Boolean.valueOf(!isOpaqueDown && worldIn.func_180495_p(down.func_177974_f()).func_185914_p())).func_177226_a((IProperty)ATTACH_WEST, (Comparable)Boolean.valueOf(!isOpaqueDown && worldIn.func_180495_p(down.func_177976_e()).func_185914_p()));
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        TileEntityCheeseVat te = (TileEntityCheeseVat)this.getTileEntity((IBlockAccess)world, pos);
        if (te != null) {
            return te.calcRedstone();
        }
        return 0;
    }

    @Override
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        TileEntity tileEntity = world.func_175625_s(data.getPos());
        if (tileEntity instanceof TileEntityCheeseVat) {
            probeInfo.horizontal(probeInfo.defaultLayoutStyle()).text("Status: " + ((TileEntityCheeseVat)tileEntity).getVatState());
            int tileEntityProgress = ((TileEntityCheeseVat)tileEntity).getDeviceProgressScaled(100);
            if (tileEntityProgress > 0) {
                probeInfo.horizontal(probeInfo.defaultLayoutStyle()).progress(((TileEntityCheeseVat)tileEntity).getDeviceProgressScaled(100), 100, probeInfo.defaultProgressStyle().suffix("%"));
            }
        }
    }
}

