/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.milk;

import growthcraft.milk.common.CommonProxy;
import growthcraft.milk.common.Init;
import growthcraft.milk.common.handlers.EntityDropsEventHandler;
import growthcraft.milk.common.handlers.HarvestDropsEventHandler;
import growthcraft.milk.shared.GrowthcraftMilkUserApis;
import growthcraft.milk.shared.config.GrowthcraftMilkConfig;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.EventBus;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="growthcraft_milk", name="Growthcraft Milk", version="4.1.3.200", dependencies="required-after:growthcraft;after:growthcraft_bees", acceptedMinecraftVersions="[1.12.2]")
public class GrowthcraftMilk {
    static final String CLIENT_PROXY_CLASS = "growthcraft.milk.client.ClientProxy";
    static final String SERVER_PROXY_CLASS = "growthcraft.milk.common.CommonProxy";
    @Mod.Instance(value="growthcraft_milk")
    public static GrowthcraftMilk instance;
    @SidedProxy(serverSide="growthcraft.milk.common.CommonProxy", clientSide="growthcraft.milk.client.ClientProxy")
    public static CommonProxy proxy;
    public static final GrowthcraftMilkConfig config;
    public static Logger logger;
    public static final GrowthcraftMilkUserApis userApis;
    public static final EventBus MILK_BUS;

    @Mod.EventHandler
    public static void preInit(FMLPreInitializationEvent event) {
        config.preInit(event, "growthcraft/growthcraft-milk.cfg");
        MinecraftForge.EVENT_BUS.register((Object)new HarvestDropsEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new EntityDropsEventHandler());
        userApis.setConfigDirectory(event.getModConfigurationDirectory());
        Init.preInitFluids();
        Init.preInitBlocks();
        Init.preInitItems();
        Init.preInitEffects();
        Init.perInitCheese();
        userApis.preInit();
        userApis.register();
        proxy.preInit();
    }

    @Mod.EventHandler
    public static void init(FMLInitializationEvent event) {
        proxy.init();
        Init.initFluids();
        Init.initRecipes();
        userApis.init();
        userApis.loadConfigs();
        Init.initBoozes();
    }

    @Mod.EventHandler
    public static void postInit(FMLPostInitializationEvent event) {
        userApis.postInit();
        Init.registerItemOres();
        Init.registerFluidOres();
    }

    @Mod.EventHandler
    public void construct(FMLConstructionEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        IForgeRegistry registry = event.getRegistry();
        Init.registerBlocks((IForgeRegistry<Block>)registry);
        Init.registerFluidBlocks((IForgeRegistry<Block>)registry);
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        Init.registerItems((IForgeRegistry<Item>)registry);
        Init.registerBlockItems((IForgeRegistry<Item>)registry);
        Init.registerFluidItems((IForgeRegistry<Item>)registry);
        proxy.postRegisterItems();
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void registerModels(ModelRegistryEvent event) {
        Init.registerItemRenders();
        Init.registerBlockRenders();
        Init.registerFluidRenders();
    }

    @SubscribeEvent
    public void registerCraftingRecipes(RegistryEvent.Register<IRecipe> event) {
        IForgeRegistry registry = event.getRegistry();
        Init.registerCraftingRecipes((IForgeRegistry<IRecipe>)registry);
    }

    static {
        config = new GrowthcraftMilkConfig();
        logger = LogManager.getLogger((String)"growthcraft_milk");
        userApis = new GrowthcraftMilkUserApis();
        FluidRegistry.enableUniversalBucket();
        MILK_BUS = new EventBus();
    }
}

