/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.cellar.shared.processing.heatsource;

import growthcraft.cellar.shared.processing.heatsource.GenericHeatSourceBlock;
import growthcraft.cellar.shared.processing.heatsource.IHeatSourceBlock;
import growthcraft.core.shared.GrowthcraftLogger;
import java.util.HashMap;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;

public class HeatSourceRegistry {
    public static final float DEFAULT_HEAT = 1.0f;
    public static final float NO_HEAT = 0.0f;
    private HeatSourceTree heatSources = new HeatSourceTree();

    public void addHeatSource(@Nonnull Block block, int meta, IHeatSourceBlock heat) {
        if (!this.heatSources.containsKey(block)) {
            this.heatSources.put(block, new HeatMap());
        }
        HeatMap map = (HeatMap)this.heatSources.get(block);
        map.put(meta, heat);
        GrowthcraftLogger.getLogger("growthcraft_cellar").debug("Added new HeatSource block=%s", (Object)block);
    }

    public void addHeatSource(@Nonnull Block block, int meta, float heat) {
        this.addHeatSource(block, meta, new GenericHeatSourceBlock(block, heat));
    }

    public void addHeatSource(@Nonnull Block block, int meta) {
        this.addHeatSource(block, meta, 1.0f);
    }

    public void addHeatSource(@Nonnull Block block, IHeatSourceBlock heat) {
        this.addHeatSource(block, Short.MAX_VALUE, heat);
    }

    public void addHeatSource(@Nonnull Block block) {
        this.addHeatSource(block, Short.MAX_VALUE);
    }

    public IHeatSourceBlock getHeatSource(IBlockState state) {
        Block block = state.func_177230_c();
        int meta = block.func_176201_c(state);
        return this.getHeatSource(block, meta);
    }

    public IHeatSourceBlock getHeatSource(Block block, int meta) {
        HeatMap map = (HeatMap)this.heatSources.get(block);
        if (map == null) {
            return null;
        }
        IHeatSourceBlock f = (IHeatSourceBlock)map.get(meta);
        if (f == null) {
            f = (IHeatSourceBlock)map.get(Short.MAX_VALUE);
        }
        if (f == null) {
            return null;
        }
        return f;
    }

    public IHeatSourceBlock getHeatSource(Block block) {
        return this.getHeatSource(block, Short.MAX_VALUE);
    }

    public boolean isBlockHeatSource(Block block, int meta) {
        HeatMap map = (HeatMap)this.heatSources.get(block);
        if (map == null) {
            return false;
        }
        return map.get(meta) != null || map.get(Short.MAX_VALUE) != null;
    }

    public boolean isBlockHeatSource(Block block) {
        return this.isBlockHeatSource(block, Short.MAX_VALUE);
    }

    static class HeatSourceTree
    extends HashMap<Block, HeatMap> {
        public static final long serialVersionUID = 1L;

        HeatSourceTree() {
        }
    }

    static class HeatMap
    extends HashMap<Integer, IHeatSourceBlock> {
        public static final long serialVersionUID = 1L;

        HeatMap() {
        }
    }
}

