/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.cellar.common.tileentity.device;

import growthcraft.cellar.common.tileentity.TileEntityFermentBarrel;
import growthcraft.cellar.shared.CellarRegistry;
import growthcraft.cellar.shared.config.GrowthcraftCellarConfig;
import growthcraft.cellar.shared.processing.fermenting.IFermentationRecipe;
import growthcraft.core.shared.definition.IMultiItemStacks;
import growthcraft.core.shared.fluids.GrowthcraftFluidUtils;
import growthcraft.core.shared.io.nbt.NBTHelper;
import growthcraft.core.shared.item.ItemUtils;
import growthcraft.core.shared.tileentity.device.DeviceFluidSlot;
import growthcraft.core.shared.tileentity.device.DeviceInventorySlot;
import growthcraft.core.shared.tileentity.device.DeviceProgressive;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;

public class FermentBarrel
extends DeviceProgressive<IFermentationRecipe> {
    private DeviceInventorySlot fermentSlot;
    private DeviceFluidSlot fluidSlot;

    public FermentBarrel(TileEntityFermentBarrel te, int fermentSlotId, int fluidSlotId) {
        super(te);
        this.timeMax = GrowthcraftCellarConfig.fermentTime;
        this.fermentSlot = new DeviceInventorySlot(te, fermentSlotId);
        this.fluidSlot = new DeviceFluidSlot(te, fluidSlotId);
    }

    @Override
    protected IFermentationRecipe loadRecipe() {
        return CellarRegistry.instance().fermenting().findRecipe(GrowthcraftFluidUtils.removeStackTags(this.fluidSlot.get()), this.fermentSlot.get());
    }

    @Override
    protected boolean canProcess() {
        IFermentationRecipe recipe = (IFermentationRecipe)this.getWorkingRecipe();
        if (recipe == null) {
            return false;
        }
        if (!recipe.getInputFluidStack().containsFluidStack(this.fluidSlot.get())) {
            return false;
        }
        return recipe.getFermentingItemStack().containsItemStack(this.fermentSlot.get());
    }

    @Override
    public void process(IFermentationRecipe recipe) {
        ItemStack fermentItem = this.fermentSlot.get();
        if (!ItemUtils.isEmpty(fermentItem) && recipe != null) {
            FluidStack outputFluidStack = recipe.getOutputFluidStack();
            if (outputFluidStack != null) {
                this.fluidSlot.set(GrowthcraftFluidUtils.exchangeFluid(this.fluidSlot.get(), outputFluidStack.getFluid()));
            }
            if (CellarRegistry.instance().fermenting().isFallbackRecipe(recipe)) {
                this.fermentSlot.consume(1);
            } else {
                IMultiItemStacks fermenter = recipe.getFermentingItemStack();
                if (!ItemUtils.isEmpty(fermenter)) {
                    this.fermentSlot.consume(fermenter.getStackSize());
                }
            }
        }
    }

    @Override
    public void legacyReadFromNBT(NBTTagCompound data) {
        this.time = 0.0;
        if (data.func_74764_b("time")) {
            this.time = NBTHelper.getInteger(data, "time");
        }
    }
}

