/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.milk.common.tileentity.device;

import growthcraft.core.shared.fluids.IFluidTanks;
import growthcraft.core.shared.tileentity.device.DeviceFluidSlot;
import growthcraft.core.shared.tileentity.device.DeviceProgressive;
import growthcraft.milk.shared.MilkRegistry;
import growthcraft.milk.shared.processing.pancheon.IPancheonRecipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.FluidStack;

public class Pancheon
extends DeviceProgressive {
    private DeviceFluidSlot inputSlot;
    private DeviceFluidSlot topSlot;
    private DeviceFluidSlot bottomSlot;

    public Pancheon(TileEntity te, int fsInput, int fsTop, int fsBottom) {
        super(te);
        if (!(te instanceof IFluidTanks)) {
            throw new IllegalArgumentException("The provided TileEntity MUST implement the IFluidTanks interface");
        }
        IFluidTanks ifl = (IFluidTanks)te;
        this.inputSlot = new DeviceFluidSlot(ifl, fsInput);
        this.topSlot = new DeviceFluidSlot(ifl, fsTop);
        this.bottomSlot = new DeviceFluidSlot(ifl, fsBottom);
    }

    private IPancheonRecipe getRecipe() {
        return MilkRegistry.instance().pancheon().getRecipe(this.inputSlot.get());
    }

    public IPancheonRecipe getWorkingRecipe() {
        IPancheonRecipe recipe = this.getRecipe();
        if (recipe == null) {
            return null;
        }
        if (!this.topSlot.hasMatchingWithCapacity(recipe.getTopOutputFluid())) {
            return null;
        }
        if (!this.bottomSlot.hasMatchingWithCapacity(recipe.getBottomOutputFluid())) {
            return null;
        }
        return recipe;
    }

    private void commitRecipe() {
        IPancheonRecipe recipe = this.getRecipe();
        if (recipe != null) {
            FluidStack bottom;
            this.inputSlot.consume(recipe.getInputFluid().amount, true);
            FluidStack top = recipe.getTopOutputFluid();
            if (top != null) {
                this.topSlot.fill(top, true);
            }
            if ((bottom = recipe.getBottomOutputFluid()) != null) {
                this.bottomSlot.fill(bottom, true);
            }
        }
    }

    @Override
    public void update() {
        IPancheonRecipe recipe = this.getWorkingRecipe();
        if (recipe != null) {
            this.setTimeMax(recipe.getTime());
            this.increaseTime();
            if (this.time >= this.timeMax) {
                this.resetTime();
                this.commitRecipe();
            }
            this.markDirtyAndUpdate(true);
        } else if (this.resetTime()) {
            this.markDirtyAndUpdate(false);
        }
    }
}

