/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.fishtrap.common.tileentity;

import growthcraft.core.shared.tileentity.feature.IInteractionObject;
import growthcraft.fishtrap.common.container.ContainerFishtrap;
import growthcraft.fishtrap.common.utils.GrowthcraftPlaySound;
import growthcraft.fishtrap.shared.config.GrowthcraftFishtrapConfig;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStaticLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.oredict.OreDictionary;

public class TileEntityFishtrap
extends TileEntity
implements ITickable,
ICapabilityProvider,
IInteractionObject {
    private int cooldown = 0;
    private int randomMaxCooldown = this.intMaxCooldown;
    private int intMinCooldown = 256;
    private int intMaxCooldown = 1024;
    private Random rand;
    private ItemStackHandler handlerOutput = new ItemStackHandler(6){

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            TileEntityFishtrap.this.func_70296_d();
        }
    };
    private ItemStackHandler handlerInput = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            TileEntityFishtrap.this.func_70296_d();
        }
    };

    public TileEntityFishtrap() {
        this.rand = new Random();
    }

    private int getRandomCooldown() {
        return this.rand.nextInt(this.intMaxCooldown - this.intMinCooldown + 1) + this.intMinCooldown;
    }

    private void doFishing() {
        if (!this.func_145831_w().field_72995_K) {
            if (GrowthcraftFishtrapConfig.strictBait && !this.hasBait(GrowthcraftFishtrapConfig.strictBait) || GrowthcraftFishtrapConfig.baitRequired && !this.hasBait()) {
                return;
            }
            LootContext.Builder lootContextBuilder = new LootContext.Builder((WorldServer)this.field_145850_b);
            List result = this.field_145850_b.func_184146_ak().func_186521_a(this.getLootTableList()).func_186462_a(new Random(), lootContextBuilder.func_186471_a());
            for (ItemStack itemstack : result) {
                if (this.isInventoryFull((IItemHandler)this.handlerOutput)) continue;
                this.addStackToInventory((IItemHandler)this.handlerOutput, itemstack, false);
            }
        }
        GrowthcraftPlaySound.onlyNearByPlayers(this.field_145850_b, this.field_174879_c, SoundEvents.field_187907_gg, SoundCategory.BLOCKS, 3);
    }

    public boolean hasBait() {
        return this.hasBait(false);
    }

    public boolean hasBait(boolean strict) {
        if (strict) {
            NonNullList oreDictionaryBaitFishing = OreDictionary.getOres((String)"baitFishing");
            ItemStack baitStack = this.handlerInput.getStackInSlot(0);
            for (ItemStack itemStack : oreDictionaryBaitFishing) {
                if (!itemStack.func_77977_a().contentEquals(baitStack.func_77977_a())) continue;
                return true;
            }
            return false;
        }
        return this.handlerInput.getStackInSlot(0).func_190916_E() > 0;
    }

    private ResourceLocation getLootTableList() {
        ResourceLocation lootTableList = LootTableList.field_186387_al;
        if (this.handlerInput.getStackInSlot(0).func_190916_E() > 0) {
            this.handlerInput.getStackInSlot(0).func_190918_g(1);
            lootTableList = LootTableList.field_186390_ao;
        }
        return lootTableList;
    }

    private ItemStack addStackToInventory(IItemHandler handler, ItemStack stack, boolean simulate) {
        ItemStack remainder = stack;
        for (int slot = 0; slot < handler.getSlots() && (remainder = handler.insertItem(slot, stack, simulate)) != ItemStack.field_190927_a; ++slot) {
        }
        return remainder;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74782_a("handler_output", (NBTBase)this.handlerOutput.serializeNBT());
        compound.func_74782_a("handler_input", (NBTBase)this.handlerInput.serializeNBT());
        return super.func_189515_b(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        this.handlerOutput.deserializeNBT(compound.func_74775_l("handler_output"));
        this.handlerInput.deserializeNBT(compound.func_74775_l("handler_input"));
        super.func_145839_a(compound);
    }

    private boolean isInventoryFull(IItemHandler handler) {
        int filledSlots = 0;
        for (int slot = 0; slot < handler.getSlots(); ++slot) {
            if (handler.getStackInSlot(slot).func_190916_E() != handler.getSlotLimit(slot)) continue;
            ++filledSlots;
        }
        return filledSlots == handler.getSlots();
    }

    public void func_73660_a() {
        ++this.cooldown;
        this.cooldown %= this.randomMaxCooldown;
        if (this.cooldown == 0) {
            this.randomMaxCooldown = this.getRandomCooldown();
            if (this.inWater() && !this.isInventoryFull((IItemHandler)this.handlerOutput)) {
                this.doFishing();
            }
        }
    }

    private boolean inWater() {
        boolean underFluid = true;
        BlockPos[] neighborBlockPos = new BlockPos[]{this.field_174879_c.func_177972_a(EnumFacing.NORTH), this.field_174879_c.func_177972_a(EnumFacing.EAST), this.field_174879_c.func_177972_a(EnumFacing.SOUTH), this.field_174879_c.func_177972_a(EnumFacing.WEST)};
        BlockPos[] upDownNeighborBlockPos = new BlockPos[]{this.field_174879_c.func_177972_a(EnumFacing.UP), this.field_174879_c.func_177972_a(EnumFacing.DOWN)};
        for (BlockPos neighborPos : neighborBlockPos) {
            IBlockState state = this.field_145850_b.func_180495_p(neighborPos);
            Block block = state.func_177230_c();
            if (block instanceof BlockStaticLiquid) continue;
            underFluid = false;
            break;
        }
        if (!underFluid) {
            Block block0 = this.field_145850_b.func_180495_p(upDownNeighborBlockPos[0]).func_177230_c();
            Block block1 = this.field_145850_b.func_180495_p(upDownNeighborBlockPos[1]).func_177230_c();
            if (block0 instanceof BlockStaticLiquid && block1 instanceof BlockStaticLiquid) {
                underFluid = true;
            }
        }
        return underFluid;
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound compound = new NBTTagCompound();
        this.func_189515_b(compound);
        int metadata = this.func_145832_p();
        return new SPacketUpdateTileEntity(this.field_174879_c, metadata, compound);
    }

    @SideOnly(value=Side.CLIENT)
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound compound = new NBTTagCompound();
        this.func_189515_b(compound);
        return compound;
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        this.func_145839_a(tag);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == null) {
                return (T)new CombinedInvWrapper(new IItemHandlerModifiable[]{this.handlerInput, this.handlerOutput});
            }
            switch (facing) {
                case UP: {
                    return (T)this.handlerInput;
                }
                case EAST: {
                    return null;
                }
                case WEST: {
                    return null;
                }
                case NORTH: {
                    return null;
                }
                case SOUTH: {
                    return null;
                }
            }
            return (T)this.handlerOutput;
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(@Nullable Capability<?> capability, @Nullable EnumFacing facing) {
        return this.getCapability(capability, facing) != null;
    }

    @Override
    public Container createContainer(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new ContainerFishtrap((IInventory)playerInventory, this);
    }

    @Override
    public String getGuiID() {
        return "growthcraft_fishtrap:fishtrap";
    }
}

