/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core.shared.utils;

import growthcraft.core.shared.utils.BBox;
import net.minecraft.util.math.AxisAlignedBB;

public class BoundUtils {
    public static final double[] NORMALIZED_CLAMP = new double[]{0.0, 0.0, 0.0, 1.0, 1.0, 1.0};

    private BoundUtils() {
    }

    public static double[] clampBounds(double[] target, double[] clamp) {
        assert (target.length == 6);
        if (target[0] < clamp[0]) {
            target[0] = clamp[0];
        }
        if (target[1] < clamp[1]) {
            target[1] = clamp[1];
        }
        if (target[2] < clamp[2]) {
            target[2] = clamp[2];
        }
        if (target[3] > clamp[3]) {
            target[3] = clamp[3];
        }
        if (target[4] > clamp[4]) {
            target[4] = clamp[4];
        }
        if (target[5] > clamp[5]) {
            target[5] = clamp[5];
        }
        return target;
    }

    public static double[] clampBounds(double[] target) {
        return BoundUtils.clampBounds(target, NORMALIZED_CLAMP);
    }

    public static double[] addBounds(double[] target, double[] expander) {
        assert (target.length == 6);
        target[0] = target[0] + expander[0];
        target[1] = target[1] + expander[1];
        target[2] = target[2] + expander[2];
        target[3] = target[3] + expander[3];
        target[4] = target[4] + expander[4];
        target[5] = target[5] + expander[5];
        return target;
    }

    public static double[] subBounds(double[] target, double[] contractor) {
        assert (target.length == 6);
        target[0] = target[0] - contractor[0];
        target[1] = target[1] - contractor[1];
        target[2] = target[2] - contractor[2];
        target[3] = target[3] - contractor[3];
        target[4] = target[4] - contractor[4];
        target[5] = target[5] - contractor[5];
        return target;
    }

    public static double[] newBoundsArray() {
        return new double[6];
    }

    public static double[] translateBounds(double[] target, double x, double y, double z, double[] src) {
        assert (target.length == 6);
        target[0] = src[0] + x;
        target[1] = src[1] + y;
        target[2] = src[2] + z;
        target[3] = src[3] + x;
        target[4] = src[4] + y;
        target[5] = src[5] + z;
        return target;
    }

    public static double[] scaleBounds(double[] target, double scale, double x, double y, double z, double x2, double y2, double z2) {
        assert (target.length == 6);
        target[0] = x * scale;
        target[1] = y * scale;
        target[2] = z * scale;
        target[3] = x2 * scale;
        target[4] = y2 * scale;
        target[5] = z2 * scale;
        return target;
    }

    public static double[] scaleBounds(double[] target, double scale, double[] src) {
        assert (src.length == 6);
        return BoundUtils.scaleBounds(target, scale, src[0], src[1], src[2], src[3], src[4], src[5]);
    }

    public static double[] newScaledBounds(double scale, double x, double y, double z, double x2, double y2, double z2) {
        double[] result = BoundUtils.newBoundsArray();
        return BoundUtils.scaleBounds(result, scale, x, y, z, x2, y2, z2);
    }

    public static double[] cubeToBounds(double[] target, double x, double y, double z, double w, double d, double h) {
        assert (target.length == 6);
        target[0] = x;
        target[1] = y;
        target[2] = z;
        target[3] = x + w;
        target[4] = y + d;
        target[5] = z + h;
        return target;
    }

    public static double[] cubeToBounds(double[] target, double[] src) {
        assert (src.length == 6);
        return BoundUtils.cubeToBounds(target, src[0], src[1], src[2], src[3], src[4], src[5]);
    }

    public static double[] newCubeToBounds(double x, double y, double z, double w, double d, double h) {
        double[] result = BoundUtils.newBoundsArray();
        return BoundUtils.cubeToBounds(result, x, y, z, w, d, h);
    }

    public static double[] centeredCubeBounds(double[] target, double w, double d, double h) {
        double x = (1.0 - w) / 2.0;
        double y = (1.0 - d) / 2.0;
        double z = (1.0 - h) / 2.0;
        return BoundUtils.cubeToBounds(target, x, y, z, w, d, h);
    }

    public static double[] newCubeFromPoints(double[] ... points) {
        double[] result = BoundUtils.newBoundsArray();
        result[0] = Double.MAX_VALUE;
        result[1] = Double.MAX_VALUE;
        result[2] = Double.MAX_VALUE;
        result[3] = -4.9E-324;
        result[4] = -4.9E-324;
        result[5] = -4.9E-324;
        for (int i = 0; i < points.length; ++i) {
            BoundUtils.mutableExpandCubeByPoints(result, points[i]);
        }
        return result;
    }

    private static void mutableExpandCubeByPoints(double[] result, double[] point) {
        for (int i = 0; i < 3; ++i) {
            if (result[i] > point[i]) {
                result[i] = point[i];
            }
            if (!(result[i + 3] < point[i])) continue;
            result[i + 3] = point[i];
        }
    }

    public static double[] newCenteredCubeBounds(double w, double d, double h) {
        return BoundUtils.centeredCubeBounds(BoundUtils.newBoundsArray(), w, d, h);
    }

    public static AxisAlignedBB rotateBlockBounds(AxisAlignedBB source, int amountCW) {
        if ((amountCW %= 4) == 0) {
            return source;
        }
        double[] p1 = new double[]{source.field_72340_a, source.field_72338_b, source.field_72339_c};
        double[] p2 = new double[]{source.field_72336_d, source.field_72337_e, source.field_72334_f};
        p1 = BoundUtils.rotatePointInBlockHor(p1, amountCW);
        p2 = BoundUtils.rotatePointInBlockHor(p2, amountCW);
        return BoundUtils.toAxisAlignedBB(BoundUtils.newCubeFromPoints(p1, p2));
    }

    private static double[] rotatePointInBlockHor(double[] point, int amountCW) {
        if ((amountCW %= 4) < 0) {
            amountCW = 4 - amountCW;
        }
        double[] newPoint = new double[]{point[0], point[1], point[2]};
        switch (amountCW) {
            case 1: {
                newPoint[0] = point[2];
                newPoint[2] = 1.0 - point[0];
                break;
            }
            case 2: {
                newPoint[0] = 1.0 - point[0];
                newPoint[2] = 1.0 - point[2];
                break;
            }
            case 3: {
                newPoint[0] = 1.0 - point[2];
                newPoint[2] = point[0];
                break;
            }
        }
        return newPoint;
    }

    public static AxisAlignedBB toAxisAlignedBB(BBox box) {
        return box.toAxisAlignedBB();
    }

    public static AxisAlignedBB toAxisAlignedBB(double[] box) {
        return new AxisAlignedBB(box[0], box[1], box[2], box[3], box[4], box[5]);
    }
}

