/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core.shared.block;

import growthcraft.core.shared.GrowthcraftLogger;
import growthcraft.core.shared.block.GrowthcraftBlockBase;
import growthcraft.core.shared.block.IDroppableBlock;
import growthcraft.core.shared.block.IWrenchable;
import growthcraft.core.shared.events.EventTankDrained;
import growthcraft.core.shared.fluids.GrowthcraftFluidUtils;
import growthcraft.core.shared.inventory.InventoryProcessor;
import growthcraft.core.shared.io.nbt.INBTItemSerializable;
import growthcraft.core.shared.item.IItemTileBlock;
import growthcraft.core.shared.item.ItemUtils;
import growthcraft.core.shared.tileentity.feature.ICustomDisplayName;
import growthcraft.core.shared.tileentity.feature.IFluidTankOperable;
import growthcraft.core.shared.tileentity.feature.IItemOperable;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.eventhandler.Event;

public abstract class GrowthcraftBlockContainer
extends GrowthcraftBlockBase
implements IDroppableBlock,
IWrenchable,
ITileEntityProvider {
    protected Random rand = new Random();
    protected Class<? extends TileEntity> tileEntityType;

    public GrowthcraftBlockContainer(@Nonnull Material material) {
        super(material);
        this.field_149758_A = true;
    }

    public GrowthcraftBlockContainer(@Nonnull Material material, @Nonnull MapColor mapColor) {
        super(material, mapColor);
        this.field_149758_A = true;
    }

    public boolean func_189539_a(IBlockState state, World worldIn, BlockPos pos, int id, int param) {
        super.func_189539_a(state, worldIn, pos, id, param);
        Object te = this.getTileEntity((IBlockAccess)worldIn, pos);
        return te != null ? te.func_145842_c(id, param) : false;
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    protected void setTileEntityType(Class<? extends TileEntity> klass) {
        this.tileEntityType = klass;
    }

    protected void fellBlockFromWrench(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        if (this.shouldDropTileStack((IBlockAccess)world, pos, state, 0)) {
            GrowthcraftLogger.getLogger("growthcraft").info("Dropping Tile As ItemStack");
            this.getTileItemStackDrops(drops, (IBlockAccess)world, pos, state, 0);
            for (ItemStack stack : drops) {
                ItemUtils.spawnItemStack(world, pos, stack, world.field_73012_v);
            }
            Object te = this.getTileEntity((IBlockAccess)world, pos);
            if (te instanceof IInventory) {
                GrowthcraftLogger.getLogger("growthcraft").info("Clearing Inventory");
                InventoryProcessor.instance().clearSlots((IInventory)te);
            }
            GrowthcraftLogger.getLogger("growthcraft").info("Setting Block To Air");
            world.func_175698_g(pos);
        } else {
            this.fellBlockAsItem(world, pos);
        }
    }

    @Override
    public boolean wrenchBlock(World world, BlockPos pos, EntityPlayer player, ItemStack wrench) {
        if (player == null) {
            return false;
        }
        if (!ItemUtils.canWrench(wrench, player, pos)) {
            return false;
        }
        if (!player.func_70093_af()) {
            return false;
        }
        if (!world.field_72995_K) {
            this.fellBlockFromWrench(world, pos);
            ItemUtils.wrenchUsed(wrench, player, pos);
        }
        return true;
    }

    public boolean tryWrenchItem(EntityPlayer player, World world, BlockPos pos) {
        if (player == null) {
            return false;
        }
        ItemStack is = player.field_71071_by.func_70448_g();
        return this.wrenchBlock(world, pos, player, is);
    }

    protected void setupCustomDisplayName(World world, BlockPos pos, ItemStack stack) {
        Object te;
        if (stack.func_82837_s() && (te = this.getTileEntity((IBlockAccess)world, pos)) instanceof ICustomDisplayName) {
            ((ICustomDisplayName)te).setGuiDisplayName(stack.func_82833_r());
        }
    }

    protected NBTTagCompound getTileTagCompound(World world, BlockPos pos, ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item instanceof IItemTileBlock) {
            IItemTileBlock itb = (IItemTileBlock)item;
            return itb.getTileTagCompound(stack);
        }
        GrowthcraftLogger.getLogger("growthcraft").error("Cannot get tile tag compound for a non IItemTileBlock: stack=%s block=%s", (Object)stack, (Object)this);
        return null;
    }

    protected void setTileTagCompound(IBlockAccess world, BlockPos pos, ItemStack stack, NBTTagCompound tag) {
        Item item = stack.func_77973_b();
        if (item instanceof IItemTileBlock) {
            IItemTileBlock itb = (IItemTileBlock)item;
            itb.setTileTagCompound(stack, tag);
        } else {
            GrowthcraftLogger.getLogger("growthcraft").error("Cannot set tile tag compound for a non IItemTileBlock: stack=%s block=%s", (Object)stack, (Object)this);
        }
    }

    protected boolean shouldRestoreBlockState(World world, BlockPos pos, ItemStack stack) {
        return false;
    }

    protected void restoreBlockStateFromStack(World world, BlockPos pos, ItemStack stack) {
        if (this.shouldRestoreBlockState(world, pos, stack)) {
            Object te = this.getTileEntity((IBlockAccess)world, pos);
            if (te instanceof INBTItemSerializable) {
                NBTTagCompound tag = this.getTileTagCompound(world, pos, stack);
                if (tag != null) {
                    ((INBTItemSerializable)te).readFromNBTForItem(tag);
                }
            } else {
                GrowthcraftLogger.getLogger("growthcraft").error("Cannot restore tile from stack, the TileEntity does not support INBTItemSerializable: stack=%s block=%s tile=%s", (Object)stack, (Object)this, te);
            }
        }
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        this.restoreBlockStateFromStack(worldIn, pos, stack);
        this.setupCustomDisplayName(worldIn, pos, stack);
    }

    protected void scatterInventory(World world, BlockPos pos, Block block) {
        IInventory inventory;
        Object te = this.getTileEntity((IBlockAccess)world, pos);
        if (te instanceof IInventory && (inventory = (IInventory)te) != null) {
            for (int index = 0; index < inventory.func_70302_i_(); ++index) {
                ItemStack stack = inventory.func_70301_a(index);
                if (!ItemUtils.isEmpty(stack)) {
                    ItemUtils.spawnItemStack(world, pos, stack, this.rand);
                }
                inventory.func_70299_a(index, (ItemStack)null);
            }
            world.func_175666_e(pos, block);
        }
    }

    protected boolean shouldScatterInventoryOnBreak(World world, BlockPos pos) {
        return true;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        if (this.shouldScatterInventoryOnBreak(worldIn, pos)) {
            this.scatterInventory(worldIn, pos, state.func_177230_c());
        }
        worldIn.func_175713_t(pos);
    }

    protected ItemStack createHarvestedBlockItemStack(World world, EntityPlayer player, BlockPos pos, IBlockState state) {
        return this.func_180643_i(state);
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        player.func_71064_a(StatList.func_188055_a((Block)this), 1);
        player.func_71020_j(0.025f);
        if (this.canSilkHarvest(worldIn, pos, state, player) && EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)stack) > 0) {
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            ItemStack itemstack = this.createHarvestedBlockItemStack(worldIn, player, pos, state);
            if (!ItemUtils.isEmpty(itemstack)) {
                items.add(itemstack);
            }
            ForgeEventFactory.fireBlockHarvesting(items, (World)worldIn, (BlockPos)pos, (IBlockState)state, (int)0, (float)1.0f, (boolean)true, (EntityPlayer)player);
            for (ItemStack is : items) {
                GrowthcraftBlockContainer.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)is);
            }
        } else {
            this.harvesters.set(player);
            int fortune = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)stack);
            this.func_176226_b(worldIn, pos, state, fortune);
            this.harvesters.set(null);
        }
    }

    protected boolean shouldDropTileStack(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        return false;
    }

    private void getDefaultDrops(List<ItemStack> ret, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        int count = this.quantityDropped(state, fortune, this.rand);
        for (int i = 0; i < count; ++i) {
            Item item = this.func_180660_a(state, this.rand, fortune);
            if (item == null) continue;
            ret.add(new ItemStack(item, 1, this.func_180651_a(state)));
        }
    }

    protected void getTileItemStackDrops(List<ItemStack> ret, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        Object te = this.getTileEntity(world, pos);
        if (te instanceof INBTItemSerializable) {
            NBTTagCompound tag = new NBTTagCompound();
            ((INBTItemSerializable)te).writeToNBTForItem(tag);
            ItemStack stack = new ItemStack((Block)this, 1, this.func_176201_c(state));
            this.setTileTagCompound(world, pos, stack, tag);
            ret.add(stack);
        } else {
            this.getDefaultDrops(ret, world, pos, state, fortune);
        }
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        if (this.shouldDropTileStack(world, pos, state, fortune)) {
            this.getTileItemStackDrops(ret, world, pos, state, fortune);
        } else {
            this.getDefaultDrops(ret, world, pos, state, fortune);
        }
        return ret;
    }

    protected boolean playerFillTank(World world, BlockPos pos, IFluidHandler tank, ItemStack is, EntityPlayer player) {
        return GrowthcraftFluidUtils.playerFillTank(world, pos, tank, is, player);
    }

    protected boolean playerDrainTank(World world, BlockPos pos, IFluidHandler tank, ItemStack is, EntityPlayer player) {
        FluidStack fs = GrowthcraftFluidUtils.playerDrainTank(world, pos, tank, is, player);
        if (fs != null && fs.amount > 0) {
            MinecraftForge.EVENT_BUS.post((Event)new EventTankDrained(player, world, pos, fs));
            return true;
        }
        return false;
    }

    private boolean handleIFluidHandler(World world, BlockPos pos, EntityPlayer player, IBlockState state) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof IFluidTankOperable) {
            if (world.field_72995_K) {
                return true;
            }
            IFluidHandler fh = (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
            if (fh != null) {
                ItemStack is = player.field_71071_by.func_70448_g();
                boolean needUpdate = false;
                if (!player.func_70093_af()) {
                    if (this.playerDrainTank(world, pos, fh, is, player) || this.playerFillTank(world, pos, fh, is, player)) {
                        needUpdate = true;
                    }
                } else if (this.playerFillTank(world, pos, fh, is, player) || this.playerDrainTank(world, pos, fh, is, player)) {
                    needUpdate = true;
                }
                if (needUpdate) {
                    this.markBlockForUpdate(world, pos);
                    return true;
                }
            }
        }
        return false;
    }

    protected boolean handleOnUseItem(IItemOperable.Action action, World world, BlockPos pos, EntityPlayer player) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof IItemOperable) {
            if (world.field_72995_K) {
                return true;
            }
            IItemOperable ih = (IItemOperable)te;
            ItemStack is = player.field_71071_by.func_70448_g();
            boolean needUpdate = false;
            if (ih.tryPlaceItem(action, player, is)) {
                needUpdate = true;
            } else if (ih.tryTakeItem(action, player, is)) {
                needUpdate = true;
            }
            if (needUpdate) {
                this.markBlockForUpdate(world, pos);
                return true;
            }
        }
        return false;
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer player) {
        TileEntity te;
        if (!world.field_72995_K && (te = world.func_175625_s(pos)) instanceof IItemOperable && this.handleOnUseItem(IItemOperable.Action.LEFT, world, pos, player)) {
            return;
        }
        super.func_180649_a(world, pos, player);
    }

    public final boolean grcOnBlockActivated(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (this.tryWrenchItem(playerIn, worldIn, pos)) {
            return true;
        }
        if (this.handleIFluidHandler(worldIn, pos, playerIn, state)) {
            return true;
        }
        return this.handleOnUseItem(IItemOperable.Action.RIGHT, worldIn, pos, playerIn);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return this.grcOnBlockActivated(worldIn, pos, state, playerIn, hand, facing, hitX, hitY, hitZ);
    }

    public <T extends TileEntity> T getTileEntity(IBlockAccess world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te != null && this.tileEntityType.isInstance(te)) {
            return (T)te;
        }
        return null;
    }

    public TileEntity func_149915_a(World world, int unused) {
        if (this.tileEntityType != null) {
            try {
                return this.tileEntityType.newInstance();
            }
            catch (InstantiationException e) {
                throw new IllegalStateException("Failed to create a new instance of an illegal class " + this.tileEntityType, e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Failed to create a new instance of " + this.tileEntityType + ", because lack of permissions", e);
            }
        }
        return null;
    }
}

