/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.cellar.shared.booze;

import growthcraft.cellar.shared.booze.BoozeEffect;
import growthcraft.core.shared.CoreRegistry;
import growthcraft.core.shared.fluids.FluidTag;
import java.util.Collection;
import javax.annotation.Nonnull;
import net.minecraftforge.fluids.Fluid;

public class BoozeEntry {
    private int healAmount;
    private float saturation;
    private final Fluid fluid;
    private final BoozeEffect effect;

    public BoozeEntry(@Nonnull Fluid flus) {
        this.fluid = flus;
        this.effect = new BoozeEffect(this.fluid);
    }

    public BoozeEntry setFoodStats(int heal, float sat) {
        this.healAmount = heal;
        this.saturation = sat;
        return this;
    }

    public int getHealAmount() {
        return this.healAmount;
    }

    public float getSaturation() {
        return this.saturation;
    }

    public BoozeEffect getEffect() {
        return this.effect;
    }

    public Fluid getFluid() {
        return this.fluid;
    }

    public Collection<FluidTag> getTags() {
        return CoreRegistry.instance().fluidDictionary().getFluidTags(this.fluid);
    }

    public void addTags(FluidTag ... newtags) {
        CoreRegistry.instance().fluidDictionary().addFluidTags(this.fluid, newtags);
    }

    public boolean hasTags(FluidTag ... checktags) {
        return CoreRegistry.instance().fluidDictionary().hasFluidTags(this.fluid, checktags);
    }
}

