/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.cellar.common.tileentity.device;

import growthcraft.cellar.common.tileentity.TileEntityFermentBarrel;
import growthcraft.cellar.shared.CellarRegistry;
import growthcraft.cellar.shared.config.GrowthcraftCellarConfig;
import growthcraft.cellar.shared.processing.fermenting.IFermentationRecipe;
import growthcraft.core.shared.definition.IMultiItemStacks;
import growthcraft.core.shared.fluids.GrowthcraftFluidUtils;
import growthcraft.core.shared.io.nbt.NBTHelper;
import growthcraft.core.shared.item.ItemUtils;
import growthcraft.core.shared.tileentity.device.DeviceBase;
import growthcraft.core.shared.tileentity.device.DeviceFluidSlot;
import growthcraft.core.shared.tileentity.device.DeviceInventorySlot;
import io.netty.buffer.ByteBuf;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;

public class FermentBarrel
extends DeviceBase {
    private int timemax = GrowthcraftCellarConfig.fermentTime;
    private boolean shouldUseCachedRecipe = GrowthcraftCellarConfig.fermentBarrelUseCachedRecipe;
    protected int time;
    private boolean recheckRecipe = true;
    private IFermentationRecipe activeRecipe;
    private DeviceInventorySlot fermentSlot;
    private DeviceInventorySlot tapSlot;
    private DeviceFluidSlot fluidSlot;

    public FermentBarrel(TileEntityFermentBarrel te, int fermentSlotId, int tapSlotId, int fluidSlotId) {
        super(te);
        this.fermentSlot = new DeviceInventorySlot(te, fermentSlotId);
        this.tapSlot = new DeviceInventorySlot(te, tapSlotId);
        this.fluidSlot = new DeviceFluidSlot(te, fluidSlotId);
    }

    public void markForRecipeRecheck() {
        this.recheckRecipe = true;
    }

    protected boolean resetTime() {
        if (this.time != 0) {
            this.time = 0;
            return true;
        }
        return false;
    }

    private IFermentationRecipe loadRecipe() {
        return CellarRegistry.instance().fermenting().findRecipe(GrowthcraftFluidUtils.removeStackTags(this.fluidSlot.get()), this.fermentSlot.get());
    }

    private IFermentationRecipe refreshRecipe() {
        IFermentationRecipe recipe = this.loadRecipe();
        if (recipe != null && recipe != this.activeRecipe) {
            if (this.activeRecipe != null) {
                this.resetTime();
            }
            this.activeRecipe = recipe;
            this.markDirty();
        } else if (this.activeRecipe != null) {
            this.activeRecipe = null;
            this.resetTime();
            this.markDirty();
        }
        return this.activeRecipe;
    }

    private IFermentationRecipe getWorkingRecipe() {
        if (this.shouldUseCachedRecipe) {
            if (this.activeRecipe == null) {
                this.refreshRecipe();
            }
            return this.activeRecipe;
        }
        return this.loadRecipe();
    }

    public void setTime(int time) {
        this.time = time;
    }

    public int getTime() {
        return this.time;
    }

    public int getTimeMax() {
        return this.timemax;
    }

    public void setTimeMax(int timeMax) {
        this.timemax = timeMax;
    }

    private boolean canFerment() {
        if (ItemUtils.isEmpty(this.fermentSlot.get())) {
            return false;
        }
        if (this.fluidSlot.isEmpty()) {
            return false;
        }
        return this.getWorkingRecipe() != null;
    }

    public void fermentItem() {
        IFermentationRecipe recipe;
        ItemStack fermentItem = this.fermentSlot.get();
        if (!ItemUtils.isEmpty(fermentItem) && (recipe = this.getWorkingRecipe()) != null) {
            FluidStack outputFluidStack = recipe.getOutputFluidStack();
            if (outputFluidStack != null) {
                this.fluidSlot.set(GrowthcraftFluidUtils.exchangeFluid(this.fluidSlot.get(), outputFluidStack.getFluid()));
            }
            if (CellarRegistry.instance().fermenting().isFallbackRecipe(recipe)) {
                this.fermentSlot.consume(1);
            } else {
                IMultiItemStacks fermenter = recipe.getFermentingItemStack();
                if (!ItemUtils.isEmpty(fermenter)) {
                    this.fermentSlot.consume(fermenter.getStackSize());
                }
            }
        }
    }

    public float getProgress() {
        int tmx = this.getTimeMax();
        if (tmx > 0) {
            return (float)this.time / (float)tmx;
        }
        return 0.0f;
    }

    public int getProgressScaled(int scale) {
        int tmx = this.getTimeMax();
        if (tmx > 0) {
            return this.time * scale / tmx;
        }
        return 0;
    }

    public void update() {
        IFermentationRecipe recipe;
        if (this.recheckRecipe) {
            this.recheckRecipe = false;
            this.refreshRecipe();
        }
        if ((recipe = this.getWorkingRecipe()) != null) {
            this.timemax = recipe.getTime();
        }
        if (this.canFerment()) {
            ++this.time;
            if (this.time >= this.getTimeMax()) {
                this.resetTime();
                this.fermentItem();
            }
            this.markDirtyAndUpdate(false);
        } else if (this.time != 0) {
            this.resetTime();
            this.markDirtyAndUpdate(false);
        }
    }

    @Override
    public void legacyReadFromNBT(NBTTagCompound data) {
        this.time = 0;
        if (data.func_74764_b("time")) {
            this.time = NBTHelper.getInteger(data, "time");
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        this.time = NBTHelper.getInteger(data, "time");
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        data.func_74768_a("time", this.time);
    }

    @Override
    public boolean readFromStream(ByteBuf buf) {
        this.time = buf.readInt();
        this.timemax = buf.readInt();
        return false;
    }

    @Override
    public boolean writeToStream(ByteBuf buf) {
        buf.writeInt(this.time);
        buf.writeInt(this.timemax);
        return false;
    }
}

