/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.bees.shared.config;

import growthcraft.core.shared.GrowthcraftLogger;
import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import org.apache.logging.log4j.Level;

public class GrowthcraftBeesConfig {
    private static Configuration configuration;
    private static final String CATEGORY_GENERAL = "general";
    private static final String CATEGORY_BEEBOX = "beebox";
    private static final String CATEGORY_BEEHIVE = "beehive";
    public static boolean isDebug;
    public static String logLevel;
    public static boolean honeyEnabled;
    public static float beeBoxHoneyCombSpawnRate;
    public static float beeBoxHoneySpawnRate;
    public static float beeBoxBeeSpawnRate;
    public static float beeBoxFlowerSpawnRate;
    public static int beeBoxFlowerRadius;
    public static float beeBoxBonusMultiplier;
    public static int honeyMeadColor;
    public static boolean worldgenBeeHive;
    public static int worldgenBeeHiveRarity;
    public static int worldGenBeeHiveRadius;
    public static int maxBeeHivesPerChunk;

    private GrowthcraftBeesConfig() {
    }

    public static void preInit(FMLPreInitializationEvent e) {
        File directory = e.getModConfigurationDirectory();
        configuration = new Configuration(new File(directory.getPath(), "growthcraft/growthcraft-bees.cfg"));
        GrowthcraftBeesConfig.readConfig();
    }

    public static void readConfig() {
        try {
            configuration.load();
            GrowthcraftBeesConfig.initGeneralConfig();
            GrowthcraftBeesConfig.initDebugConfig();
        }
        catch (Exception e) {
            GrowthcraftLogger.getLogger("growthcraft").log(Level.ERROR, "Unable to load configuration files for Growthcraft Bees!", (Throwable)e);
        }
        finally {
            if (configuration.hasChanged()) {
                configuration.save();
            }
        }
    }

    private static void initGeneralConfig() {
        honeyEnabled = configuration.getBoolean("enableHoney", CATEGORY_GENERAL, honeyEnabled, "Enable Growthcraft Fluid Honey.");
        beeBoxHoneyCombSpawnRate = configuration.getFloat("honeyCombGenerationRate", CATEGORY_BEEBOX, beeBoxHoneyCombSpawnRate, 0.0f, 100.0f, "The rate that honey comb is generated in the bee box.");
        beeBoxHoneySpawnRate = configuration.getFloat("honeyGenerationRate", CATEGORY_BEEBOX, beeBoxHoneySpawnRate, 0.0f, 100.0f, "The rate that honey is generated with honey combs in the bee box.");
        beeBoxBeeSpawnRate = configuration.getFloat("beeGenerationRate", CATEGORY_BEEBOX, beeBoxBeeSpawnRate, 0.0f, 100.0f, "The rate that bees are generated in the bee box.");
        beeBoxFlowerSpawnRate = configuration.getFloat("flowerGenerationRate", CATEGORY_BEEBOX, beeBoxFlowerSpawnRate, 0.0f, 100.0f, "The rate that flowers are generated around the bee box.");
        beeBoxFlowerRadius = configuration.getInt("flowerGenerationRadius", CATEGORY_BEEBOX, beeBoxFlowerRadius, 1, 10, "Radius of flower generation.");
        beeBoxBonusMultiplier = configuration.getFloat("flowerGenerationRate", CATEGORY_BEEBOX, beeBoxBonusMultiplier, 0.0f, 10.0f, "The rate that flowers are generated around the bee box.");
        worldgenBeeHive = configuration.getBoolean("generateBeeHives", CATEGORY_BEEHIVE, worldgenBeeHive, "Generate BeeHives in the world.");
        worldgenBeeHiveRarity = configuration.getInt("beeHiveRarity", CATEGORY_BEEHIVE, worldgenBeeHiveRarity, 0, 100, "Rarity of BeeHive generation. Higher the value, more likely it will generate in chunk.");
        worldGenBeeHiveRadius = configuration.getInt("worldGenBeeHiveRadius", CATEGORY_BEEHIVE, worldGenBeeHiveRadius, 1, 7, "Maximum radius from the center of the chunk that a beeHive will be generated.");
        maxBeeHivesPerChunk = configuration.getInt("maxBeeHivesPerChunk", CATEGORY_BEEHIVE, maxBeeHivesPerChunk, 1, 16, "Maximum number of beeHives that will be generated per chunk.");
    }

    private static void initDebugConfig() {
        if ((logLevel = configuration.getString("logLevel", CATEGORY_GENERAL, logLevel, "Set standard logging levels. (INFO, ERROR, DEBUG)")).equalsIgnoreCase("debug")) {
            isDebug = true;
        }
    }

    static {
        isDebug = false;
        logLevel = "info";
        honeyEnabled = true;
        beeBoxHoneyCombSpawnRate = 18.75f;
        beeBoxHoneySpawnRate = 6.25f;
        beeBoxBeeSpawnRate = 6.25f;
        beeBoxFlowerSpawnRate = 6.25f;
        beeBoxFlowerRadius = 5;
        beeBoxBonusMultiplier = 2.5f;
        honeyMeadColor = 10707212;
        worldgenBeeHive = true;
        worldgenBeeHiveRarity = 3;
        worldGenBeeHiveRadius = 6;
        maxBeeHivesPerChunk = 1;
    }
}

