/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.rice.shared.config;

import growthcraft.core.shared.GrowthcraftLogger;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import org.apache.logging.log4j.Level;

public class GrowthcraftRiceConfig
extends Configuration {
    private static Configuration configuration;
    private static final String CATEGORY_GENERAL = "general";
    private static final String CATEGORY_CELLAR = "growthcraft-cellar-interop";
    public static boolean isDebug;
    public static String logLevel;
    public static int riceGrowthRate;
    public static int riceGrowthMinLight;
    public static boolean boneMealIgnoreLight;
    public static boolean enableDiscardButton;
    public static int fermentTime;
    public static int brewTime;
    public static int sakeMashColor;
    public static int sakePotentColor;
    public static int sakeExtendedColor;
    public static int sakeYoungColor;
    public static int sakeHyperExtendedColor;
    public static int sakeIntoxicatedColor;
    public static int sakePoisonedColor;
    public static int CULTIVATOR_HARVEST_TABLE_CHANCE;
    public static List<String> CULTIVATOR_HARVEST_TABLE;
    public static List<String> ADD_GRASS_DROPS;

    private GrowthcraftRiceConfig() {
    }

    public static void preInit(FMLPreInitializationEvent e) {
        File directory = e.getModConfigurationDirectory();
        configuration = new Configuration(new File(directory.getPath(), "growthcraft/growthcraft-rice.cfg"));
        GrowthcraftRiceConfig.readConfig();
    }

    public static void readConfig() {
        try {
            configuration.load();
            GrowthcraftRiceConfig.initGeneralConfig();
            GrowthcraftRiceConfig.initDebugConfig();
        }
        catch (Exception e) {
            GrowthcraftLogger.getLogger("growthcraft").log(Level.ERROR, "Unable to load configuration files for Growthcraft Rice!", (Throwable)e);
        }
        finally {
            if (configuration.hasChanged()) {
                configuration.save();
            }
        }
    }

    private static void initGeneralConfig() {
        boneMealIgnoreLight = configuration.getBoolean("boneMealIgnoreLight", CATEGORY_GENERAL, boneMealIgnoreLight, "Allow for bonemeal to force growth regardless of light level.");
        riceGrowthMinLight = configuration.getInt("riceGrowthMinLight", CATEGORY_GENERAL, riceGrowthMinLight, 1, 15, "Minimum light level for rice to grow. Midnight (4), Sunlight/Thunderstorms (8), Sunlight (12).");
        riceGrowthRate = configuration.getInt("riceGrowthRate", CATEGORY_GENERAL, riceGrowthRate, 1, 100, "Percentage chance of rice growing.");
        fermentTime = configuration.getInt("fermentTime", CATEGORY_GENERAL, fermentTime, 100, 4000, "General fermentation time for Growthcraft Rice Booze.");
        enableDiscardButton = configuration.getBoolean("enableDiscardButton", CATEGORY_GENERAL, enableDiscardButton, "Allow users to be able to dump the fluid in the fermentor.");
        brewTime = configuration.getInt("brewTime", CATEGORY_CELLAR, brewTime, 1, 10, "Time in minutes for cooking rice in the brew kettle.");
        CULTIVATOR_HARVEST_TABLE = Arrays.asList(configuration.getStringList("cultivator_harvest_table", CATEGORY_GENERAL, CULTIVATOR_HARVEST_TABLE.toArray(new String[0]), "Add the item's registry name on a new line for each item you want the culivator to drop when it cultivates."));
        CULTIVATOR_HARVEST_TABLE_CHANCE = configuration.getInt("cultivator_harvest_table_chance", CATEGORY_GENERAL, CULTIVATOR_HARVEST_TABLE_CHANCE, 1, 100, "1 in X chances something will drop while using the cultivator. Larger the int the more likely it will drop.");
        ADD_GRASS_DROPS = Arrays.asList(configuration.getStringList("add_grass_drops", CATEGORY_GENERAL, ADD_GRASS_DROPS.toArray(new String[0]), "Add a new with the registry name of the item you want to add to the grassSeed drop table."));
    }

    private static void initDebugConfig() {
        if ((logLevel = configuration.getString("logLevel", CATEGORY_GENERAL, logLevel, "Set standard logging levels. (INFO, ERROR, DEBUG)")).equalsIgnoreCase("debug")) {
            isDebug = true;
        }
    }

    static {
        isDebug = false;
        logLevel = "info";
        riceGrowthRate = 25;
        riceGrowthMinLight = 5;
        boneMealIgnoreLight = false;
        enableDiscardButton = true;
        fermentTime = 24000;
        brewTime = 1;
        sakeMashColor = 15331319;
        sakePotentColor = 15331319;
        sakeExtendedColor = 15331319;
        sakeYoungColor = 15331319;
        sakeHyperExtendedColor = 15331319;
        sakeIntoxicatedColor = 15331319;
        sakePoisonedColor = 15331319;
        CULTIVATOR_HARVEST_TABLE_CHANCE = 10;
        CULTIVATOR_HARVEST_TABLE = new ArrayList<String>(){
            {
                this.add("growthcraft_rice:rice");
            }
        };
        ADD_GRASS_DROPS = new ArrayList<String>(){
            {
                this.add("growthcraft_rice:rice");
            }
        };
    }
}

