/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.rice.common;

import growthcraft.cellar.shared.GrowthcraftCellarApis;
import growthcraft.cellar.shared.booze.BoozeRegistryHelper;
import growthcraft.cellar.shared.booze.BoozeTag;
import growthcraft.cellar.shared.booze.BoozeUtils;
import growthcraft.cellar.shared.config.GrowthcraftCellarConfig;
import growthcraft.cellar.shared.definition.BlockBoozeDefinition;
import growthcraft.cellar.shared.definition.BoozeDefinition;
import growthcraft.cellar.shared.fluids.Booze;
import growthcraft.cellar.shared.item.ItemBoozeBottle;
import growthcraft.cellar.shared.processing.common.Residue;
import growthcraft.cellar.shared.utils.BoozeHelper;
import growthcraft.core.shared.GrowthcraftCoreApis;
import growthcraft.core.shared.client.render.utils.ItemRenderUtils;
import growthcraft.core.shared.config.GrowthcraftCoreConfig;
import growthcraft.core.shared.definition.BlockDefinition;
import growthcraft.core.shared.definition.ItemDefinition;
import growthcraft.core.shared.definition.ItemTypeDefinition;
import growthcraft.core.shared.utils.TickUtils;
import growthcraft.rice.common.block.BlockPaddy;
import growthcraft.rice.common.block.BlockRiceCrop;
import growthcraft.rice.common.item.ItemCultivator;
import growthcraft.rice.common.item.ItemFoodRice;
import growthcraft.rice.common.item.ItemRice;
import growthcraft.rice.common.item.ItemRiceBall;
import growthcraft.rice.shared.config.GrowthcraftRiceConfig;
import growthcraft.rice.shared.init.GrowthcraftRiceBlocks;
import growthcraft.rice.shared.init.GrowthcraftRiceFluids;
import growthcraft.rice.shared.init.GrowthcraftRiceItems;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistry;

public class Init {
    private Init() {
    }

    public static void preInitBlocks() {
        GrowthcraftRiceBlocks.ricePaddy = new BlockDefinition(new BlockPaddy("ricePaddy"));
        GrowthcraftRiceBlocks.riceCrop = new BlockDefinition((Block)new BlockRiceCrop("riceCrop"));
    }

    public static void registerBlocks(IForgeRegistry<Block> registry) {
        GrowthcraftRiceBlocks.ricePaddy.getBlock().func_149647_a(GrowthcraftCoreApis.tabGrowthcraft);
        GrowthcraftRiceBlocks.ricePaddy.registerBlock(registry);
        GrowthcraftRiceBlocks.riceCrop.getBlock().func_149647_a(GrowthcraftCoreApis.tabGrowthcraft);
        GrowthcraftRiceBlocks.riceCrop.registerBlock(registry);
    }

    public static void registerBlockItems(IForgeRegistry<Item> registry) {
        GrowthcraftRiceBlocks.ricePaddy.registerBlockItem(registry);
        GrowthcraftRiceBlocks.riceCrop.registerBlockItem(registry);
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerBlockRenders() {
        GrowthcraftRiceBlocks.ricePaddy.registerItemRender();
        GrowthcraftRiceBlocks.riceCrop.registerItemRender();
    }

    public static void registerTileEntities() {
    }

    public static void preInitItems() {
        GrowthcraftRiceItems.cultivator = new ItemDefinition((Item)new ItemCultivator("cultivator"));
        GrowthcraftRiceItems.rice = new ItemDefinition((Item)new ItemRice("rice"));
        GrowthcraftRiceItems.rice_ball = new ItemDefinition((Item)new ItemRiceBall("rice_ball"));
        GrowthcraftRiceItems.rice_cooked = new ItemDefinition((Item)new ItemFoodRice("rice_cooked"));
        GrowthcraftRiceItems.sakeBottle = new ItemTypeDefinition<ItemBoozeBottle>(new ItemBoozeBottle());
    }

    public static void registerItemOres() {
        OreDictionary.registerOre((String)"cropRice", (ItemStack)GrowthcraftRiceItems.rice.asStack());
        OreDictionary.registerOre((String)"foodRice", (ItemStack)GrowthcraftRiceItems.rice_cooked.asStack());
        OreDictionary.registerOre((String)"foodRice", (ItemStack)GrowthcraftRiceItems.rice_ball.asStack());
        OreDictionary.registerOre((String)"listAllRice", (ItemStack)GrowthcraftRiceItems.rice.asStack());
        OreDictionary.registerOre((String)"listAllRice", (ItemStack)GrowthcraftRiceItems.rice_cooked.asStack());
        OreDictionary.registerOre((String)"listAllRice", (ItemStack)GrowthcraftRiceItems.rice_ball.asStack());
        OreDictionary.registerOre((String)"seedRice", (ItemStack)GrowthcraftRiceItems.rice.asStack());
    }

    public static void registerItems(IForgeRegistry<Item> registry) {
        GrowthcraftRiceItems.cultivator.registerItem(registry);
        GrowthcraftRiceItems.cultivator.getItem().func_77637_a(GrowthcraftCoreApis.tabGrowthcraft);
        GrowthcraftRiceItems.sakeBottle.registerItem(registry, new ResourceLocation("growthcraft_rice", "sakebottle"));
        GrowthcraftRiceItems.sakeBottle.getItem().func_77637_a(GrowthcraftCoreApis.tabGrowthcraft);
        GrowthcraftRiceItems.sakeBottle.getItem().setBoozes(GrowthcraftRiceFluids.sakeBooze);
        GrowthcraftRiceItems.rice_cooked.registerItem(registry);
        GrowthcraftRiceItems.rice_cooked.getItem().func_77637_a(GrowthcraftCoreApis.tabGrowthcraft);
        GrowthcraftRiceItems.rice.registerItem(registry);
        GrowthcraftRiceItems.rice.getItem().func_77637_a(GrowthcraftCoreApis.tabGrowthcraft);
        MinecraftForge.addGrassSeed((ItemStack)GrowthcraftRiceItems.rice.asStack(), (int)1);
        GrowthcraftRiceItems.rice_ball.registerItem(registry);
        GrowthcraftRiceItems.rice_ball.getItem().func_77637_a(GrowthcraftCoreApis.tabGrowthcraft);
        for (String itemRegistryName : GrowthcraftRiceConfig.ADD_GRASS_DROPS) {
            Item item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(itemRegistryName));
            if (item == null) continue;
            ItemStack itemStack = new ItemStack(item);
            MinecraftForge.addGrassSeed((ItemStack)itemStack, (int)1);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerItemRenders() {
        GrowthcraftRiceItems.cultivator.registerRender();
        GrowthcraftRiceItems.sakeBottle.registerRenders(GrowthcraftRiceItems.SakeTypes.class);
        GrowthcraftRiceItems.rice_cooked.registerRender();
        GrowthcraftRiceItems.rice.registerRender();
        GrowthcraftRiceItems.rice_ball.registerRender();
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerItemColorHandlers() {
        ItemRenderUtils.registerItemColorHandler((Item)GrowthcraftRiceItems.sakeBottle.getItem());
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerItemVariants() {
        GrowthcraftRiceItems.sakeBottle.registerModelBakeryVariants(GrowthcraftRiceItems.SakeTypes.class);
    }

    public static void preInitFluids() {
        GrowthcraftRiceFluids.sakeBooze = new BoozeDefinition[GrowthcraftRiceItems.SakeTypes.values().length];
        BoozeRegistryHelper.initializeAndRegisterBoozeFluids(GrowthcraftRiceFluids.sakeBooze, GrowthcraftRiceItems.SakeTypes.class, "");
        ((Booze)GrowthcraftRiceFluids.sakeBooze[GrowthcraftRiceItems.SakeTypes.SAKE_MASH.ordinal()].getFluid()).setColor(GrowthcraftRiceConfig.sakeMashColor).setDensity(1120);
        ((Booze)GrowthcraftRiceFluids.sakeBooze[GrowthcraftRiceItems.SakeTypes.SAKE_POTENT.ordinal()].getFluid()).setColor(GrowthcraftRiceConfig.sakePotentColor).setDensity(1120);
        ((Booze)GrowthcraftRiceFluids.sakeBooze[GrowthcraftRiceItems.SakeTypes.SAKE_EXTENDED.ordinal()].getFluid()).setColor(GrowthcraftRiceConfig.sakeExtendedColor).setDensity(1120);
        ((Booze)GrowthcraftRiceFluids.sakeBooze[GrowthcraftRiceItems.SakeTypes.SAKE_FERMENTED.ordinal()].getFluid()).setColor(GrowthcraftRiceConfig.sakeYoungColor).setDensity(1120);
        ((Booze)GrowthcraftRiceFluids.sakeBooze[GrowthcraftRiceItems.SakeTypes.SAKE_HYPEREXTENDED.ordinal()].getFluid()).setColor(GrowthcraftRiceConfig.sakeHyperExtendedColor).setDensity(1120);
        ((Booze)GrowthcraftRiceFluids.sakeBooze[GrowthcraftRiceItems.SakeTypes.SAKE_POISONED.ordinal()].getFluid()).setColor(GrowthcraftRiceConfig.sakePoisonedColor).setDensity(1120);
    }

    public static void registerFluidBlocks(IForgeRegistry<Block> registry) {
        GrowthcraftRiceBlocks.sakeFluidBlocks = new BlockBoozeDefinition[GrowthcraftRiceFluids.sakeBooze.length];
        BoozeRegistryHelper.initializeBooze(GrowthcraftRiceFluids.sakeBooze, GrowthcraftRiceBlocks.sakeFluidBlocks);
        BoozeRegistryHelper.setBoozeFoodStats(GrowthcraftRiceFluids.sakeBooze, 1, -0.3f);
        BoozeRegistryHelper.setBoozeFoodStats(GrowthcraftRiceFluids.sakeBooze[GrowthcraftRiceItems.SakeTypes.SAKE_FERMENTED.ordinal()], 1, 0.3f);
        BoozeRegistryHelper.registerBoozeBlocks(registry, GrowthcraftRiceFluids.sakeBooze, GrowthcraftRiceBlocks.sakeFluidBlocks, "growthcraft_rice", "sakebooze", GrowthcraftRiceItems.SakeTypes.class);
    }

    public static void initBoozes() {
        BoozeRegistryHelper.initBoozeContainers(GrowthcraftRiceFluids.sakeBooze, GrowthcraftRiceItems.sakeBottle, "growthcraft_rice", "sakebooze", GrowthcraftRiceItems.SakeTypes.class);
        Init.registerFermentations();
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerFluidRenders() {
        BoozeRegistryHelper.registerBoozeRenderers(GrowthcraftRiceFluids.sakeBooze, GrowthcraftRiceBlocks.sakeFluidBlocks);
    }

    private static void registerFermentations() {
        int fermentTime = GrowthcraftCellarConfig.fermentTime;
        FluidStack[] fs = BoozeHelper.boozeDefintionsToFluidStacks(GrowthcraftRiceFluids.sakeBooze);
        FluidStack[] spoilInputFs = BoozeHelper.boozeDefintionsToFluidStacks(GrowthcraftRiceFluids.sakeBooze, 200);
        GrowthcraftCellarApis.boozeBuilderFactory.create((Fluid)GrowthcraftRiceFluids.sakeBooze[GrowthcraftRiceItems.SakeTypes.SAKE_WATER.ordinal()].getFluid()).tags(BoozeTag.SAKE).brewsFrom(new FluidStack(FluidRegistry.WATER, 200), GrowthcraftRiceItems.rice.asStack(), true, TickUtils.minutes(GrowthcraftRiceConfig.brewTime), new Residue(GrowthcraftRiceItems.rice_cooked.asStack(), 1.0f));
        GrowthcraftCellarApis.boozeBuilderFactory.create((Fluid)GrowthcraftRiceFluids.sakeBooze[GrowthcraftRiceItems.SakeTypes.SAKE_MASH.ordinal()].getFluid()).tags(BoozeTag.SAKE, BoozeTag.MASH).brewsFrom(new FluidStack(GrowthcraftRiceFluids.sakeBooze[GrowthcraftRiceItems.SakeTypes.SAKE_WATER.ordinal()].getFluid(), 250), new ItemStack(Item.func_150898_a((Block)Blocks.field_150338_P)), false, TickUtils.minutes(1), Residue.newDefault(0.0f)).brewsFrom(new FluidStack(GrowthcraftRiceFluids.sakeBooze[GrowthcraftRiceItems.SakeTypes.SAKE_WATER.ordinal()].getFluid(), 250), new ItemStack(Item.func_150898_a((Block)Blocks.field_150337_Q)), false, TickUtils.minutes(1), Residue.newDefault(0.0f));
        GrowthcraftCellarApis.boozeBuilderFactory.create((Fluid)GrowthcraftRiceFluids.sakeBooze[GrowthcraftRiceItems.SakeTypes.SAKE_FERMENTED.ordinal()].getFluid()).tags(BoozeTag.SAKE, BoozeTag.FERMENTED).fermentsFrom(fs[GrowthcraftRiceItems.SakeTypes.SAKE_MASH.ordinal()], new ItemStack(Items.field_151075_bm), (int)((double)fermentTime * 0.66)).getEffect().setTipsy(BoozeUtils.alcoholToTipsy(0.05f), TickUtils.seconds(90)).addPotionEntry(MobEffects.field_76429_m, TickUtils.minutes(1), 0);
        GrowthcraftCellarApis.boozeBuilderFactory.create((Fluid)GrowthcraftRiceFluids.sakeBooze[GrowthcraftRiceItems.SakeTypes.SAKE_POTENT.ordinal()].getFluid()).tags(BoozeTag.SAKE, BoozeTag.FERMENTED, BoozeTag.POTENT).fermentsFrom(fs[GrowthcraftRiceItems.SakeTypes.SAKE_FERMENTED.ordinal()], new ItemStack(Items.field_151114_aO), fermentTime).getEffect().setTipsy(BoozeUtils.alcoholToTipsy(0.1f), TickUtils.seconds(90)).addPotionEntry(MobEffects.field_76429_m, TickUtils.minutes(1), 1);
        GrowthcraftCellarApis.boozeBuilderFactory.create((Fluid)GrowthcraftRiceFluids.sakeBooze[GrowthcraftRiceItems.SakeTypes.SAKE_EXTENDED.ordinal()].getFluid()).tags(BoozeTag.SAKE, BoozeTag.FERMENTED, BoozeTag.EXTENDED).fermentsFrom(fs[GrowthcraftRiceItems.SakeTypes.SAKE_FERMENTED.ordinal()], new ItemStack(Items.field_151137_ax), fermentTime).getEffect().setTipsy(BoozeUtils.alcoholToTipsy(0.05f), TickUtils.seconds(90)).addPotionEntry(MobEffects.field_76429_m, TickUtils.minutes(3), 0);
        GrowthcraftCellarApis.boozeBuilderFactory.create((Fluid)GrowthcraftRiceFluids.sakeBooze[GrowthcraftRiceItems.SakeTypes.SAKE_HYPEREXTENDED.ordinal()].getFluid()).tags(BoozeTag.SAKE, BoozeTag.FERMENTED, BoozeTag.HYPER_EXTENDED).fermentsFrom(fs[GrowthcraftRiceItems.SakeTypes.SAKE_EXTENDED.ordinal()], new ItemStack(Items.field_151137_ax), fermentTime).getEffect().setTipsy(BoozeUtils.alcoholToTipsy(0.05f), TickUtils.seconds(90)).addPotionEntry(MobEffects.field_76429_m, TickUtils.minutes(8), 0);
        GrowthcraftCellarApis.boozeBuilderFactory.create((Fluid)GrowthcraftRiceFluids.sakeBooze[GrowthcraftRiceItems.SakeTypes.SAKE_POTENT_EXTENDED.ordinal()].getFluid()).tags(BoozeTag.SAKE, BoozeTag.FERMENTED, BoozeTag.POTENT, BoozeTag.EXTENDED).fermentsFrom(fs[GrowthcraftRiceItems.SakeTypes.SAKE_POTENT.ordinal()], new ItemStack(Items.field_151137_ax), fermentTime).getEffect().setTipsy(BoozeUtils.alcoholToTipsy(0.1f), TickUtils.seconds(90)).addPotionEntry(MobEffects.field_76429_m, TickUtils.minutes(3), 1);
        GrowthcraftCellarApis.boozeBuilderFactory.create((Fluid)GrowthcraftRiceFluids.sakeBooze[GrowthcraftRiceItems.SakeTypes.SAKE_POTENT_HYPEREXTENDED.ordinal()].getFluid()).tags(BoozeTag.SAKE, BoozeTag.FERMENTED, BoozeTag.POTENT, BoozeTag.HYPER_EXTENDED).fermentsFrom(fs[GrowthcraftRiceItems.SakeTypes.SAKE_POTENT_EXTENDED.ordinal()], new ItemStack(Items.field_151137_ax), fermentTime).getEffect().setTipsy(BoozeUtils.alcoholToTipsy(0.1f), TickUtils.seconds(90)).addPotionEntry(MobEffects.field_76429_m, TickUtils.minutes(8), 1);
        GrowthcraftCellarApis.boozeBuilderFactory.create((Fluid)GrowthcraftRiceFluids.sakeBooze[GrowthcraftRiceItems.SakeTypes.SAKE_POISONED.ordinal()].getFluid()).tags(BoozeTag.SAKE, BoozeTag.FERMENTED, BoozeTag.POISONED).fermentsFromFallback(fs[GrowthcraftRiceItems.SakeTypes.SAKE_FERMENTED.ordinal()], fermentTime).brewsFromFallback(spoilInputFs[GrowthcraftRiceItems.SakeTypes.SAKE_FERMENTED.ordinal()], GrowthcraftRiceConfig.brewTime, null).fermentsFromFallback(fs[GrowthcraftRiceItems.SakeTypes.SAKE_POTENT.ordinal()], fermentTime).brewsFromFallback(spoilInputFs[GrowthcraftRiceItems.SakeTypes.SAKE_POTENT.ordinal()], GrowthcraftRiceConfig.brewTime, null).fermentsFromFallback(fs[GrowthcraftRiceItems.SakeTypes.SAKE_EXTENDED.ordinal()], fermentTime).brewsFromFallback(spoilInputFs[GrowthcraftRiceItems.SakeTypes.SAKE_EXTENDED.ordinal()], GrowthcraftRiceConfig.brewTime, null).fermentsFromFallback(fs[GrowthcraftRiceItems.SakeTypes.SAKE_HYPEREXTENDED.ordinal()], fermentTime).brewsFromFallback(spoilInputFs[GrowthcraftRiceItems.SakeTypes.SAKE_HYPEREXTENDED.ordinal()], GrowthcraftRiceConfig.brewTime, null).fermentsFromFallback(fs[GrowthcraftRiceItems.SakeTypes.SAKE_POTENT_EXTENDED.ordinal()], fermentTime).brewsFromFallback(spoilInputFs[GrowthcraftRiceItems.SakeTypes.SAKE_POTENT_EXTENDED.ordinal()], GrowthcraftRiceConfig.brewTime, null).fermentsFromFallback(fs[GrowthcraftRiceItems.SakeTypes.SAKE_POTENT_HYPEREXTENDED.ordinal()], fermentTime).brewsFromFallback(spoilInputFs[GrowthcraftRiceItems.SakeTypes.SAKE_POTENT_HYPEREXTENDED.ordinal()], GrowthcraftRiceConfig.brewTime, null).fermentsFromFallback(fs[GrowthcraftRiceItems.SakeTypes.SAKE_POISONED.ordinal()], fermentTime).brewsFromFallback(spoilInputFs[GrowthcraftRiceItems.SakeTypes.SAKE_POISONED.ordinal()], GrowthcraftRiceConfig.brewTime, null).getEffect().setTipsy(BoozeUtils.alcoholToTipsy(0.1f), TickUtils.seconds(90)).createPotionEntry(MobEffects.field_76436_u, TickUtils.seconds(90), 0).toggleDescription(!GrowthcraftCoreConfig.hidePoisonedBooze);
    }

    public static void initRecipes() {
    }

    public static void registerRecipes() {
        Init.registerCraftingRecipes();
    }

    private static void registerCraftingRecipes() {
    }

    public static void lootLoad(LootTableLoadEvent event) {
    }
}

