/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.milk.shared.processing.pancheon;

import growthcraft.core.shared.GrowthcraftLogger;
import growthcraft.milk.shared.processing.pancheon.IPancheonRecipe;
import growthcraft.milk.shared.processing.pancheon.PancheonRecipe;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class PancheonRegistry {
    private Map<Fluid, IPancheonRecipe> recipes = new HashMap<Fluid, IPancheonRecipe>();

    public void addRecipe(@Nonnull IPancheonRecipe recipe) {
        Fluid fluid = recipe.getInputFluid().getFluid();
        if (this.recipes.containsKey(fluid)) {
            GrowthcraftLogger.getLogger("growthcraft_milk").warn("Overwriting existing pancheon recipe for {%s} with {%s}", (Object)recipe.getInputFluid(), (Object)recipe);
        } else {
            GrowthcraftLogger.getLogger("growthcraft_milk").debug("Adding new pancheon recipe {%s}", (Object)recipe);
        }
        this.recipes.put(fluid, recipe);
    }

    public void addRecipe(@Nonnull FluidStack inputStack, @Nonnull FluidStack topOutput, @Nullable FluidStack bottomOutput, int time) {
        Fluid fluid = inputStack.getFluid();
        if (fluid == null) {
            throw new IllegalArgumentException("The provided input fluid is invalid.");
        }
        PancheonRecipe recipe = new PancheonRecipe(inputStack, topOutput, bottomOutput, time);
        this.addRecipe(recipe);
    }

    @Nullable
    public IPancheonRecipe getRecipe(FluidStack stack) {
        if (stack == null) {
            return null;
        }
        Fluid fluid = stack.getFluid();
        if (fluid == null) {
            return null;
        }
        IPancheonRecipe recipe = this.recipes.get(fluid);
        if (recipe != null && recipe.isValidForRecipe(stack)) {
            return recipe;
        }
        return null;
    }
}

