/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.milk.shared.processing.churn;

import growthcraft.core.shared.fluids.FluidFormatString;
import growthcraft.milk.shared.processing.churn.IChurnRecipe;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class ChurnRecipe
implements IChurnRecipe {
    private FluidStack inputFluid;
    private FluidStack outputFluid;
    private ItemStack outputItem;
    private int churns;

    public ChurnRecipe(FluidStack inFluid, FluidStack outFluid, ItemStack outItem, int ch) {
        this.inputFluid = inFluid;
        this.outputFluid = outFluid;
        this.outputItem = outItem;
        this.churns = ch;
    }

    @Override
    public boolean isValidForRecipe(FluidStack stack) {
        if (stack == null) {
            return false;
        }
        if (!this.inputFluid.isFluidEqual(stack)) {
            return false;
        }
        return stack.amount >= this.inputFluid.amount;
    }

    @Override
    public FluidStack getInputFluidStack() {
        return this.inputFluid;
    }

    @Override
    public FluidStack getOutputFluidStack() {
        return this.outputFluid;
    }

    @Override
    public ItemStack getOutputItemStack() {
        return this.outputItem;
    }

    @Override
    public int getChurns() {
        return this.churns;
    }

    public String toString() {
        return String.format("ChurnRecipe(`%s` / %d = `%s` & `%s`)", FluidFormatString.format(this.inputFluid), this.churns, FluidFormatString.format(this.outputFluid), this.outputItem);
    }
}

