/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.milk.common.tileentity;

import growthcraft.core.shared.io.nbt.INBTItemSerializable;
import growthcraft.core.shared.item.ItemTest;
import growthcraft.core.shared.item.ItemUtils;
import growthcraft.core.shared.tileentity.GrowthcraftTileBase;
import growthcraft.core.shared.tileentity.event.TileEventHandler;
import growthcraft.core.shared.tileentity.feature.IItemOperable;
import growthcraft.milk.GrowthcraftMilk;
import growthcraft.milk.common.item.ItemBlockCheeseBlock;
import growthcraft.milk.common.tileentity.struct.Cheese;
import growthcraft.milk.shared.definition.EnumCheeseStage;
import growthcraft.milk.shared.definition.ICheeseBlockStackFactory;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.List;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class TileEntityCheeseBlock
extends GrowthcraftTileBase
implements ITickable,
IItemOperable,
INBTItemSerializable {
    private Cheese cheese = new Cheese();

    public List<ItemStack> populateDrops(List<ItemStack> list) {
        boolean bHasAnySlices;
        ItemStack stack = null;
        boolean bl = bHasAnySlices = this.cheese.getTopSlices() > 0;
        if (bHasAnySlices) {
            boolean bHasFullSlices = this.cheese.getTopSlices() == this.cheese.getTopSlicesMax();
            EnumCheeseStage stage = this.cheese.getStage();
            if (bHasFullSlices && stage == EnumCheeseStage.CUT) {
                GrowthcraftMilk.logger.warn("A cut cheese wheel with full amount of slices found.");
                stage = EnumCheeseStage.AGED;
            }
            stack = this.cheese.getType().getCheeseBlocks().asStackForStage(this.cheese.getTopSlices(), stage);
        }
        if (stack != null) {
            list.add(stack);
        }
        stack = null;
        if (this.cheese.isDoubleStacked()) {
            EnumCheeseStage stage = this.cheese.getStage();
            if (stage == EnumCheeseStage.CUT) {
                stage = EnumCheeseStage.AGED;
            }
            stack = this.cheese.getType().getCheeseBlocks().asStackForStage(this.cheese.getTopSlicesMax(), stage);
        }
        if (stack != null) {
            list.add(stack);
        }
        return list;
    }

    public Cheese getCheese() {
        return this.cheese;
    }

    public int getCheeseId() {
        return this.getCheese().getId();
    }

    public int getCheeseStageId() {
        return this.getCheese().getStageId();
    }

    protected void readCheeseFromNBT(NBTTagCompound nbt) {
        this.cheese.readFromNBT(nbt);
    }

    @Override
    public void readFromNBTForItem(NBTTagCompound nbt) {
        super.readFromNBTForItem(nbt);
        this.readCheeseFromNBT(nbt);
    }

    @TileEventHandler(event=TileEventHandler.EventType.NBT_READ)
    public void readFromNBT_CheeseBlock(NBTTagCompound nbt) {
        this.readCheeseFromNBT(nbt);
    }

    protected void writeCheeseToNBT(NBTTagCompound nbt) {
        this.cheese.writeToNBT(nbt);
    }

    @Override
    public void writeToNBTForItem(NBTTagCompound nbt) {
        super.writeToNBTForItem(nbt);
        this.writeCheeseToNBT(nbt);
    }

    @TileEventHandler(event=TileEventHandler.EventType.NBT_WRITE)
    public void writeToNBT_CheeseBlock(NBTTagCompound nbt) {
        this.writeCheeseToNBT(nbt);
    }

    public ItemStack asItemStack() {
        ICheeseBlockStackFactory blockStackFactory = this.cheese.getType().getCheeseBlocks();
        int numSlices = MathHelper.func_76125_a((int)this.cheese.getSlices(), (int)0, (int)this.cheese.getTopSlicesMax());
        if (numSlices <= 0) {
            return ItemStack.field_190927_a;
        }
        ItemStack stack = blockStackFactory.asStackForStage(numSlices, blockStackFactory.getInitialStage());
        NBTTagCompound tag = ItemBlockCheeseBlock.openNBT(stack);
        this.writeToNBTForItem(tag);
        return stack;
    }

    @TileEventHandler(event=TileEventHandler.EventType.NETWORK_READ)
    public boolean readFromStream_CheeseBlock(ByteBuf stream) throws IOException {
        this.cheese.readFromStream(stream);
        return true;
    }

    @TileEventHandler(event=TileEventHandler.EventType.NETWORK_WRITE)
    public boolean writeToStream_CheeseBlock(ByteBuf stream) throws IOException {
        this.cheese.writeToStream(stream);
        return true;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.cheese.update();
            if (this.cheese.needClientUpdate) {
                this.cheese.needClientUpdate = false;
                if (this.cheese.hasSlices()) {
                    this.markForUpdate();
                } else {
                    this.field_145850_b.func_175698_g(this.func_174877_v());
                }
            }
        }
    }

    @Override
    public boolean tryPlaceItem(IItemOperable.Action action, EntityPlayer player, ItemStack onHand) {
        if (IItemOperable.Action.RIGHT != action) {
            return false;
        }
        int consumeAmount = this.cheese.canWaxing(onHand);
        if (consumeAmount > 0) {
            this.cheese.setStage(EnumCheeseStage.UNAGED);
            this.updateOnTryPlaceItem(consumeAmount, player, onHand);
            return true;
        }
        consumeAmount = this.cheese.canStack(onHand);
        if (consumeAmount > 0) {
            this.cheese.stackWheel(onHand, true);
            World world = player.func_130014_f_();
            IBlockState state = world.func_180495_p(this.field_174879_c);
            SoundType soundtype = this.func_145838_q().getSoundType(state, world, this.field_174879_c, (Entity)player);
            world.func_184133_a(null, this.field_174879_c, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
            this.updateOnTryPlaceItem(consumeAmount, player, onHand);
            return true;
        }
        return false;
    }

    private void updateOnTryPlaceItem(int consumeAmount, EntityPlayer player, ItemStack onHand) {
        if (!player.field_71075_bZ.field_75098_d) {
            if (onHand.func_190916_E() > consumeAmount) {
                onHand.func_190918_g(consumeAmount);
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, onHand);
            } else {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, ItemStack.field_190927_a);
            }
        }
        this.markDirtyAndUpdate();
    }

    @Override
    public boolean tryTakeItem(IItemOperable.Action action, EntityPlayer player, ItemStack onHand) {
        if (IItemOperable.Action.RIGHT != action) {
            return false;
        }
        if (this.cheese.isAged()) {
            if (!(onHand.func_77973_b() instanceof ItemSword) && !ItemTest.itemMatchesOre(onHand, "toolKnife")) {
                return false;
            }
            ItemStack stack = this.cheese.yankSlices(1, true);
            if (!ItemUtils.isEmpty(stack)) {
                ItemUtils.addStackToPlayer(stack, player, false);
            }
            this.markDirtyAndUpdate();
            this.cheese.needClientUpdate |= true;
            return true;
        }
        return false;
    }
}

