/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.milk.common.block;

import growthcraft.core.shared.block.BlockUtils;
import growthcraft.core.shared.block.GrowthcraftBlockContainer;
import growthcraft.core.shared.block.IRotatableBlock;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockOrientable
extends GrowthcraftBlockContainer
implements IRotatableBlock {
    public static final PropertyEnum<Orient> TYPE_ORIENT = PropertyEnum.func_177709_a((String)"orient", Orient.class);

    public BlockOrientable(Material material) {
        super(material);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a(TYPE_ORIENT, (Comparable)((Object)Orient.NORTH)));
    }

    @Override
    public boolean isRotatable(IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    public void doRotateBlock(World world, BlockPos pos, IBlockState state, EnumFacing side) {
        Orient orient = (Orient)((Object)state.func_177229_b(TYPE_ORIENT));
        switch (orient) {
            case NORTH: {
                orient = Orient.WEST;
                break;
            }
            case WEST: {
                orient = Orient.SOUTH;
                break;
            }
            case SOUTH: {
                orient = Orient.EAST;
                break;
            }
            case EAST: {
                orient = Orient.NORTH;
            }
        }
        world.func_180501_a(pos, state.func_177226_a(TYPE_ORIENT, (Comparable)((Object)orient)), 3);
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing side) {
        if (this.isRotatable((IBlockAccess)world, pos, side)) {
            IBlockState state = world.func_180495_p(pos);
            this.doRotateBlock(world, pos, state, side);
            this.markBlockForUpdate(world, pos);
            return true;
        }
        return false;
    }

    protected void setDefaultDirection(World world, BlockPos pos, IBlockState state) {
        if (!world.field_72995_K) {
            Orient facing = Orient.fromFacing(BlockUtils.getDefaultDirection(world, pos, state));
            world.func_180501_a(pos, state.func_177226_a(TYPE_ORIENT, (Comparable)((Object)facing)), 3);
        }
    }

    protected Orient setOrientWhenPlacing(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer) {
        Orient facing = Orient.fromFacing(EnumFacing.func_176733_a((double)placer.field_70177_z));
        worldIn.func_180501_a(pos, state.func_177226_a(TYPE_ORIENT, (Comparable)((Object)facing)), 3);
        return facing;
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        this.setDefaultDirection(worldIn, pos, state);
        super.func_176213_c(worldIn, pos, state);
    }

    @Override
    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        this.setOrientWhenPlacing(worldIn, pos, state, placer);
        super.func_180633_a(worldIn, pos, state, placer, stack);
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE_ORIENT});
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(TYPE_ORIENT, (Comparable)((Object)Orient.values()[meta & 3]));
    }

    public int func_176201_c(IBlockState state) {
        return ((Orient)((Object)state.func_177229_b(TYPE_ORIENT))).ordinal();
    }

    public static enum Orient implements IStringSerializable
    {
        NORTH(1),
        SOUTH(3),
        WEST(2),
        EAST(0);

        public final int rotationCW;

        private Orient(int rotationCW) {
            this.rotationCW = rotationCW;
        }

        public static Orient fromFacing(EnumFacing facing) {
            switch (facing) {
                case NORTH: {
                    return NORTH;
                }
                case SOUTH: {
                    return SOUTH;
                }
                case WEST: {
                    return WEST;
                }
            }
            return EAST;
        }

        public EnumFacing toFacing() {
            switch (this) {
                case NORTH: {
                    return EnumFacing.NORTH;
                }
                case SOUTH: {
                    return EnumFacing.SOUTH;
                }
                case WEST: {
                    return EnumFacing.WEST;
                }
            }
            return EnumFacing.EAST;
        }

        public String func_176610_l() {
            return this.toString().toLowerCase();
        }
    }
}

