/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core.shared.tileentity;

import growthcraft.core.shared.io.nbt.IAltNBTSerializable;
import growthcraft.core.shared.io.stream.IStreamable;
import growthcraft.core.shared.tileentity.event.TileEventFunction;
import growthcraft.core.shared.tileentity.event.TileEventHandler;
import growthcraft.core.shared.tileentity.event.TileEventHandlerMap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;

public abstract class GrowthcraftTileBase
extends TileEntity
implements IStreamable,
IAltNBTSerializable {
    protected static TileEventHandlerMap<GrowthcraftTileBase> HANDLERS = new TileEventHandlerMap();

    public void markForUpdate() {
        IBlockState curState = this.func_145831_w().func_180495_p(this.field_174879_c);
        this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, curState, curState, 3);
    }

    public void markDirtyAndUpdate() {
        this.func_70296_d();
        this.markForUpdate();
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (this.getCapability(capability, facing) != null) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    protected List<TileEventFunction> getHandlersFor(@Nonnull TileEventHandler.EventType event) {
        return HANDLERS.getEventFunctionsForClass(this.getClass(), event);
    }

    @Override
    public final boolean writeToStream(ByteBuf stream) {
        List<TileEventFunction> handlers = this.getHandlersFor(TileEventHandler.EventType.NETWORK_WRITE);
        if (handlers != null) {
            for (TileEventFunction func : handlers) {
                func.writeToStream(this, stream);
            }
        }
        return false;
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound data = new NBTTagCompound();
        ByteBuf stream = Unpooled.buffer();
        try {
            this.writeToStream(stream);
            if (stream.readableBytes() == 0) {
                return null;
            }
        }
        catch (Throwable t) {
            System.err.println(t);
        }
        data.func_74773_a("P", stream.array());
        return new SPacketUpdateTileEntity(this.field_174879_c, 127, data);
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = super.func_189517_E_();
        return this.func_189515_b(tag);
    }

    @Override
    public final boolean readFromStream(ByteBuf stream) {
        boolean shouldUpdate = false;
        List<TileEventFunction> handlers = this.getHandlersFor(TileEventHandler.EventType.NETWORK_READ);
        if (handlers != null) {
            for (TileEventFunction func : handlers) {
                if (!func.readFromStream(this, stream)) continue;
                shouldUpdate = true;
            }
        }
        return shouldUpdate;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        if (packet.func_148853_f() == 127) {
            ByteBuf stream;
            NBTTagCompound tag = packet.func_148857_g();
            boolean dirty = false;
            if (tag != null && this.readFromStream(stream = Unpooled.copiedBuffer((byte[])tag.func_74770_j("P")))) {
                dirty = true;
            }
            if (dirty) {
                this.markForUpdate();
            }
        }
    }

    public void readFromNBTForItem(NBTTagCompound tag) {
    }

    public void writeToNBTForItem(NBTTagCompound tag) {
    }

    public final void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        List<TileEventFunction> handlers = this.getHandlersFor(TileEventHandler.EventType.NBT_READ);
        if (handlers != null) {
            for (TileEventFunction func : handlers) {
                func.readFromNBT(this, nbt);
            }
        }
    }

    public final NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        List<TileEventFunction> handlers = this.getHandlersFor(TileEventHandler.EventType.NBT_WRITE);
        if (handlers != null) {
            for (TileEventFunction func : handlers) {
                func.writeToNBT(this, nbt);
            }
        }
        return nbt;
    }
}

