/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core.shared.item;

import growthcraft.core.shared.client.GrowthcraftCoreState;
import growthcraft.core.shared.effect.IEffect;
import growthcraft.core.shared.item.GrowthcraftItemBase;
import growthcraft.core.shared.item.ItemUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class GrowthcraftItemFoodBase
extends ItemFood {
    private IEffect effect;
    private EnumAction action = EnumAction.EAT;

    public GrowthcraftItemFoodBase(int hunger, float saturation, boolean isWolfFav) {
        super(hunger, saturation, isWolfFav);
    }

    public GrowthcraftItemFoodBase(int hunger, boolean isWolfFav) {
        super(hunger, isWolfFav);
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return this.action;
    }

    public GrowthcraftItemFoodBase setItemUseAction(EnumAction act) {
        this.action = act;
        return this;
    }

    public GrowthcraftItemFoodBase setEffect(IEffect ef) {
        this.effect = ef;
        return this;
    }

    public IEffect getEffect() {
        return this.effect;
    }

    protected void applyIEffects(ItemStack itemStack, World world, EntityPlayer player) {
        if (this.effect != null) {
            this.effect.apply(world, (Entity)player, world.field_73012_v, itemStack);
        }
    }

    protected void func_77849_c(ItemStack itemStack, World world, EntityPlayer player) {
        super.func_77849_c(itemStack, world, player);
        if (!world.field_72995_K) {
            this.applyIEffects(itemStack, world, player);
        }
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, EntityLivingBase entityLiving) {
        if (entityLiving instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entityLiving;
            if (!player.field_71075_bZ.field_75098_d && !worldIn.field_72995_K) {
                stack = stack.func_77946_l();
                ItemStack result = ItemUtils.consumeStack(stack.func_77979_a(1));
                ItemUtils.addStackToPlayer(result, player, worldIn, false);
            }
            player.func_71024_bL().func_151686_a((ItemFood)this, stack);
            worldIn.func_184148_a((EntityPlayer)null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187739_dZ, SoundCategory.PLAYERS, 0.5f, worldIn.field_73012_v.nextFloat() * 0.1f + 0.9f);
            this.func_77849_c(stack, worldIn, player);
        }
        return stack;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        GrowthcraftItemBase.addDescription((Item)this, stack, worldIn, tooltip, flagIn);
        if (this.effect != null) {
            ArrayList<String> tempList = new ArrayList<String>();
            this.effect.getDescription(tempList);
            if (tempList.size() > 0) {
                if (GrowthcraftCoreState.showDetailedInformation()) {
                    tooltip.addAll(tempList);
                } else {
                    tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"grc.tooltip.detailed_information", (Object[])new Object[]{TextFormatting.WHITE + "SHIFT" + TextFormatting.GRAY}));
                }
            }
        }
    }
}

