/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core.shared.fluids;

import growthcraft.core.shared.GrowthcraftLogger;
import growthcraft.core.shared.fluids.FluidTag;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class FluidDictionary {
    private Map<Fluid, Set<FluidTag>> fluidToTagsMap = new HashMap<Fluid, Set<FluidTag>>();
    private Map<FluidTag, Set<Fluid>> tagToFluidsMap = new HashMap<FluidTag, Set<Fluid>>();

    public void addFluidTags(@Nonnull Fluid fluid, FluidTag ... tags) {
        if (!this.fluidToTagsMap.containsKey(fluid)) {
            GrowthcraftLogger.getLogger("growthcraft").debug("Initializing new HashSet for fluid {%s}", (Object)fluid);
            this.fluidToTagsMap.put(fluid, new HashSet());
        }
        Set<FluidTag> tagSet = this.fluidToTagsMap.get(fluid);
        for (FluidTag tag : tags) {
            GrowthcraftLogger.getLogger("growthcraft").debug("Adding tag '%s' to fluid {%s}", (Object)tag, (Object)fluid);
            tagSet.add(tag);
            if (!this.tagToFluidsMap.containsKey(tag)) {
                this.tagToFluidsMap.put(tag, new HashSet());
            }
            this.tagToFluidsMap.get(tag).add(fluid);
        }
    }

    public Collection<FluidTag> getFluidTags(@Nullable Fluid fluid) {
        if (fluid == null) {
            return null;
        }
        return this.fluidToTagsMap.get(fluid);
    }

    public Collection<FluidTag> getFluidTags(@Nullable FluidStack stack) {
        if (stack == null) {
            return null;
        }
        return this.getFluidTags(stack.getFluid());
    }

    public boolean hasFluidTags(@Nonnull Fluid fluid, FluidTag ... tags) {
        Set<FluidTag> fluidTags = this.fluidToTagsMap.get(fluid);
        if (fluidTags == null) {
            return false;
        }
        for (FluidTag tag : tags) {
            if (fluidTags.contains(tag)) continue;
            return false;
        }
        return true;
    }

    public Collection<Fluid> getFluidsByTags(@Nonnull List<FluidTag> tags) {
        Set<Fluid> prim;
        HashSet<Fluid> fluids = new HashSet<Fluid>();
        if (tags.size() > 0 && (prim = this.tagToFluidsMap.get(tags.get(0))) != null) {
            fluids.addAll(prim);
            for (int i = 1; i < tags.size() && !fluids.isEmpty(); ++i) {
                Set<Fluid> exc = this.tagToFluidsMap.get(tags.get(i));
                fluids.retainAll(exc);
            }
        }
        return fluids;
    }

    public Collection<Fluid> getFluidsByTags(FluidTag ... tags) {
        return this.getFluidsByTags(Arrays.asList(tags));
    }
}

