/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core.shared.config;

import java.io.File;
import java.util.ArrayList;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class GrowthcraftCoreConfig {
    private static Configuration config = null;
    public static final String CATEGORY_NAME_GENERAL = "general";
    public static boolean hidePoisonedBooze = true;
    public static final String CATEGORY_NAME_LOGGING = "logging";
    public static String loggingLevel;
    public static final String CATEGORY_NAME_WORLDGEN = "worldgen";
    public static boolean blockSaltOreWorldGen;
    public static int blockSaltOreMinHeight;
    public static int blockSaltOreMaxHeight;
    public static int blockSaltOreChanceToSpawn;
    public static int bottleCapacity;

    public static void preInit() {
        File configFile = new File(Loader.instance().getConfigDir(), "growthcraft/growthcraft-core.cfg");
        config = new Configuration(configFile);
        GrowthcraftCoreConfig.syncFromFiles();
    }

    public static Configuration getConfig() {
        return config;
    }

    public static void clientPreInit() {
        MinecraftForge.EVENT_BUS.register((Object)new ConfigEventHandler());
    }

    public static void syncFromFiles() {
        GrowthcraftCoreConfig.syncConfig(true, true);
    }

    public static void syncFromGui() {
        GrowthcraftCoreConfig.syncConfig(false, true);
    }

    public static void syncFromFields() {
        GrowthcraftCoreConfig.syncConfig(false, false);
    }

    private static void syncConfig(boolean loadFromConfigFile, boolean readFieldsFromConfig) {
        if (loadFromConfigFile) {
            config.load();
        }
        Property propertyLogLevel = config.get(CATEGORY_NAME_LOGGING, "log_level", "info");
        propertyLogLevel.setLanguageKey("config.logging.log_level");
        propertyLogLevel.setComment(I18n.func_74838_a((String)"config.logging.log_level.comment"));
        ArrayList<String> propertyOrderLoggingBlocks = new ArrayList<String>();
        propertyOrderLoggingBlocks.add(propertyLogLevel.getName());
        config.setCategoryPropertyOrder(CATEGORY_NAME_LOGGING, propertyOrderLoggingBlocks);
        Property propertyWorldGEnBlocksaltOre = config.get(CATEGORY_NAME_WORLDGEN, "blockSaltOreWorldGen", true);
        propertyWorldGEnBlocksaltOre.setLanguageKey("config.worldgen.worldgenBlockSaltOre");
        propertyWorldGEnBlocksaltOre.setComment(I18n.func_74838_a((String)"config.worldgen.worldgenBlockSaltOre.comment"));
        Property propertyBlockSaltOreMinHeight = config.get(CATEGORY_NAME_WORLDGEN, "blockSaltOreMinHeight", 10);
        propertyBlockSaltOreMinHeight.setLanguageKey("config.worldgen.blockSaltOreMinHeight");
        propertyBlockSaltOreMinHeight.setComment(I18n.func_74838_a((String)"config.worldgen.blockSaltOreMinHeight.comment"));
        Property propertyBlockSaltOreMaxHeight = config.get(CATEGORY_NAME_WORLDGEN, "blockSaltOreMaxHeight", 64);
        propertyBlockSaltOreMaxHeight.setLanguageKey("config.worldgen.blockSaltOreMaxHeight");
        propertyBlockSaltOreMaxHeight.setComment(I18n.func_74838_a((String)"config.worldgen.blockSaltOreMaxHeight.comment"));
        Property propertyBlockSaltOreChanceToSpawn = config.get(CATEGORY_NAME_WORLDGEN, "blockSaltOreChanceToSpawn", 5);
        propertyBlockSaltOreChanceToSpawn.setLanguageKey("config.worldgen.blockSaltOreChanceToSpawn");
        propertyBlockSaltOreChanceToSpawn.setComment(I18n.func_74838_a((String)"config.worldgen.blockSaltOreChanceToSpawn.comment"));
        ArrayList<String> propertyOrderWorldGenBlocks = new ArrayList<String>();
        propertyOrderWorldGenBlocks.add(propertyWorldGEnBlocksaltOre.getName());
        propertyOrderWorldGenBlocks.add(propertyBlockSaltOreMinHeight.getName());
        propertyOrderWorldGenBlocks.add(propertyBlockSaltOreMaxHeight.getName());
        propertyOrderWorldGenBlocks.add(propertyBlockSaltOreChanceToSpawn.getName());
        config.setCategoryPropertyOrder(CATEGORY_NAME_WORLDGEN, propertyOrderWorldGenBlocks);
        Property propertyHidePoisonedBooze = config.get(CATEGORY_NAME_GENERAL, "hidePoisonedBooze", true);
        propertyHidePoisonedBooze.setLanguageKey("config.general.hidePoisonedBooze");
        propertyHidePoisonedBooze.setComment(I18n.func_74838_a((String)"config.general.hidePoisonedBooze.comment"));
        ArrayList<String> propertyOrderGeneralBlocks = new ArrayList<String>();
        propertyOrderGeneralBlocks.add(propertyHidePoisonedBooze.getName());
        config.setCategoryPropertyOrder(CATEGORY_NAME_GENERAL, propertyOrderGeneralBlocks);
        if (readFieldsFromConfig) {
            loggingLevel = propertyLogLevel.getString();
            blockSaltOreWorldGen = propertyWorldGEnBlocksaltOre.getBoolean();
            blockSaltOreMinHeight = propertyBlockSaltOreMinHeight.getInt();
            blockSaltOreMaxHeight = propertyBlockSaltOreMaxHeight.getInt();
            blockSaltOreChanceToSpawn = propertyBlockSaltOreChanceToSpawn.getInt();
            hidePoisonedBooze = propertyHidePoisonedBooze.getBoolean();
        }
        propertyLogLevel.set(loggingLevel);
        if (config.hasChanged()) {
            config.save();
        }
    }

    static {
        blockSaltOreWorldGen = true;
        blockSaltOreMinHeight = 10;
        blockSaltOreMaxHeight = 64;
        blockSaltOreChanceToSpawn = 5;
        bottleCapacity = 250;
    }

    public static class ConfigEventHandler {
        @SubscribeEvent(priority=EventPriority.LOWEST)
        public void onEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("growthcraft")) {
                GrowthcraftCoreConfig.syncFromGui();
            }
        }
    }
}

