/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core.shared.config;

import growthcraft.core.shared.GrowthcraftLogger;
import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import org.apache.logging.log4j.Level;

public class GrowthcraftConfiguration
extends Configuration {
    private static Configuration configuration;
    private static final String CATEGORY_GENERAL = "general";
    private static final String CATEGORY_BOOZE = "Booze/Effects";
    public static boolean isDebug;
    public static String logLevel;
    public static boolean hidePoisonedBooze;

    public void preInit(FMLPreInitializationEvent e) {
        File directory = e.getModConfigurationDirectory();
        configuration = new Configuration(new File(directory.getPath(), "modtut.cfg"));
        GrowthcraftConfiguration.readConfig();
    }

    public static void readConfig() {
        try {
            configuration.load();
            GrowthcraftConfiguration.initDebugConfig();
            GrowthcraftConfiguration.initBoozeConfig();
        }
        catch (Exception e) {
            GrowthcraftLogger.getLogger("growthcraft").log(Level.ERROR, "Unable to load configuration files for Growthcraft Bamboo!", (Throwable)e);
        }
        finally {
            if (configuration.hasChanged()) {
                configuration.save();
            }
        }
    }

    private static void initDebugConfig() {
        logLevel = configuration.getString("logLevel", CATEGORY_GENERAL, logLevel, "Set standard logging levels. (INFO, ERROR, DEBUG)");
    }

    private static void initBoozeConfig() {
        hidePoisonedBooze = configuration.getBoolean("hidePoisoned", CATEGORY_BOOZE, hidePoisonedBooze, "Should purposely poisoned booze have its effect hidden?");
    }

    static {
        isDebug = false;
        logLevel = "info";
        hidePoisonedBooze = true;
    }
}

